// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Workload Profile resource specific properties. </summary>
    public partial class ContainerAppWorkloadProfileStateProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppWorkloadProfileStateProperties"/>. </summary>
        public ContainerAppWorkloadProfileStateProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppWorkloadProfileStateProperties"/>. </summary>
        /// <param name="minimumCount"> Minimum count of instances. </param>
        /// <param name="maximumCount"> Maximum count of nodes. </param>
        /// <param name="currentCount"> Current count of nodes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppWorkloadProfileStateProperties(int? minimumCount, int? maximumCount, int? currentCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MinimumCount = minimumCount;
            MaximumCount = maximumCount;
            CurrentCount = currentCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Minimum count of instances. </summary>
        [WirePath("minimumCount")]
        public int? MinimumCount { get; set; }
        /// <summary> Maximum count of nodes. </summary>
        [WirePath("maximumCount")]
        public int? MaximumCount { get; set; }
        /// <summary> Current count of nodes. </summary>
        [WirePath("currentCount")]
        public int? CurrentCount { get; set; }
    }
}
