// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Storage type for the volume. If not provided, use EmptyDir. </summary>
    public readonly partial struct ContainerAppStorageType : IEquatable<ContainerAppStorageType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppStorageType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppStorageType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureFileValue = "AzureFile";
        private const string EmptyDirValue = "EmptyDir";
        private const string SecretValue = "Secret";

        /// <summary> AzureFile. </summary>
        public static ContainerAppStorageType AzureFile { get; } = new ContainerAppStorageType(AzureFileValue);
        /// <summary> EmptyDir. </summary>
        public static ContainerAppStorageType EmptyDir { get; } = new ContainerAppStorageType(EmptyDirValue);
        /// <summary> Secret. </summary>
        public static ContainerAppStorageType Secret { get; } = new ContainerAppStorageType(SecretValue);
        /// <summary> Determines if two <see cref="ContainerAppStorageType"/> values are the same. </summary>
        public static bool operator ==(ContainerAppStorageType left, ContainerAppStorageType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppStorageType"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppStorageType left, ContainerAppStorageType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppStorageType"/>. </summary>
        public static implicit operator ContainerAppStorageType(string value) => new ContainerAppStorageType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppStorageType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppStorageType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
