// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Current provisioning State of the operation. </summary>
    public readonly partial struct ContainerAppSourceControlOperationState : IEquatable<ContainerAppSourceControlOperationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppSourceControlOperationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppSourceControlOperationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InProgressValue = "InProgress";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> InProgress. </summary>
        public static ContainerAppSourceControlOperationState InProgress { get; } = new ContainerAppSourceControlOperationState(InProgressValue);
        /// <summary> Succeeded. </summary>
        public static ContainerAppSourceControlOperationState Succeeded { get; } = new ContainerAppSourceControlOperationState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ContainerAppSourceControlOperationState Failed { get; } = new ContainerAppSourceControlOperationState(FailedValue);
        /// <summary> Canceled. </summary>
        public static ContainerAppSourceControlOperationState Canceled { get; } = new ContainerAppSourceControlOperationState(CanceledValue);
        /// <summary> Determines if two <see cref="ContainerAppSourceControlOperationState"/> values are the same. </summary>
        public static bool operator ==(ContainerAppSourceControlOperationState left, ContainerAppSourceControlOperationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppSourceControlOperationState"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppSourceControlOperationState left, ContainerAppSourceControlOperationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppSourceControlOperationState"/>. </summary>
        public static implicit operator ContainerAppSourceControlOperationState(string value) => new ContainerAppSourceControlOperationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppSourceControlOperationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppSourceControlOperationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
