// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Container App container scaling rule. </summary>
    public partial class ContainerAppScaleRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppScaleRule"/>. </summary>
        public ContainerAppScaleRule()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppScaleRule"/>. </summary>
        /// <param name="name"> Scale Rule Name. </param>
        /// <param name="azureQueue"> Azure Queue based scaling. </param>
        /// <param name="custom"> Custom scale rule. </param>
        /// <param name="http"> HTTP requests based scaling. </param>
        /// <param name="tcp"> Tcp requests based scaling. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppScaleRule(string name, ContainerAppQueueScaleRule azureQueue, ContainerAppCustomScaleRule custom, ContainerAppHttpScaleRule http, ContainerAppTcpScaleRule tcp, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            AzureQueue = azureQueue;
            Custom = custom;
            Http = http;
            Tcp = tcp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Scale Rule Name. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Azure Queue based scaling. </summary>
        [WirePath("azureQueue")]
        public ContainerAppQueueScaleRule AzureQueue { get; set; }
        /// <summary> Custom scale rule. </summary>
        [WirePath("custom")]
        public ContainerAppCustomScaleRule Custom { get; set; }
        /// <summary> HTTP requests based scaling. </summary>
        [WirePath("http")]
        public ContainerAppHttpScaleRule Http { get; set; }
        /// <summary> Tcp requests based scaling. </summary>
        [WirePath("tcp")]
        public ContainerAppTcpScaleRule Tcp { get; set; }
    }
}
