// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Container App scaling configurations. </summary>
    public partial class ContainerAppScale
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppScale"/>. </summary>
        public ContainerAppScale()
        {
            Rules = new ChangeTrackingList<ContainerAppScaleRule>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppScale"/>. </summary>
        /// <param name="minReplicas"> Optional. Minimum number of container replicas. </param>
        /// <param name="maxReplicas"> Optional. Maximum number of container replicas. Defaults to 10 if not set. </param>
        /// <param name="rules"> Scaling rules. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppScale(int? minReplicas, int? maxReplicas, IList<ContainerAppScaleRule> rules, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MinReplicas = minReplicas;
            MaxReplicas = maxReplicas;
            Rules = rules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Optional. Minimum number of container replicas. </summary>
        [WirePath("minReplicas")]
        public int? MinReplicas { get; set; }
        /// <summary> Optional. Maximum number of container replicas. Defaults to 10 if not set. </summary>
        [WirePath("maxReplicas")]
        public int? MaxReplicas { get; set; }
        /// <summary> Scaling rules. </summary>
        [WirePath("rules")]
        public IList<ContainerAppScaleRule> Rules { get; }
    }
}
