// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Current provisioning State of the revision. </summary>
    public readonly partial struct ContainerAppRevisionProvisioningState : IEquatable<ContainerAppRevisionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppRevisionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppRevisionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProvisioningValue = "Provisioning";
        private const string ProvisionedValue = "Provisioned";
        private const string FailedValue = "Failed";
        private const string DeprovisioningValue = "Deprovisioning";
        private const string DeprovisionedValue = "Deprovisioned";

        /// <summary> Provisioning. </summary>
        public static ContainerAppRevisionProvisioningState Provisioning { get; } = new ContainerAppRevisionProvisioningState(ProvisioningValue);
        /// <summary> Provisioned. </summary>
        public static ContainerAppRevisionProvisioningState Provisioned { get; } = new ContainerAppRevisionProvisioningState(ProvisionedValue);
        /// <summary> Failed. </summary>
        public static ContainerAppRevisionProvisioningState Failed { get; } = new ContainerAppRevisionProvisioningState(FailedValue);
        /// <summary> Deprovisioning. </summary>
        public static ContainerAppRevisionProvisioningState Deprovisioning { get; } = new ContainerAppRevisionProvisioningState(DeprovisioningValue);
        /// <summary> Deprovisioned. </summary>
        public static ContainerAppRevisionProvisioningState Deprovisioned { get; } = new ContainerAppRevisionProvisioningState(DeprovisionedValue);
        /// <summary> Determines if two <see cref="ContainerAppRevisionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ContainerAppRevisionProvisioningState left, ContainerAppRevisionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppRevisionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppRevisionProvisioningState left, ContainerAppRevisionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppRevisionProvisioningState"/>. </summary>
        public static implicit operator ContainerAppRevisionProvisioningState(string value) => new ContainerAppRevisionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppRevisionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppRevisionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
