// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Current running state of the replica. </summary>
    public readonly partial struct ContainerAppReplicaRunningState : IEquatable<ContainerAppReplicaRunningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppReplicaRunningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppReplicaRunningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "Running";
        private const string NotRunningValue = "NotRunning";
        private const string UnknownValue = "Unknown";

        /// <summary> Running. </summary>
        public static ContainerAppReplicaRunningState Running { get; } = new ContainerAppReplicaRunningState(RunningValue);
        /// <summary> NotRunning. </summary>
        public static ContainerAppReplicaRunningState NotRunning { get; } = new ContainerAppReplicaRunningState(NotRunningValue);
        /// <summary> Unknown. </summary>
        public static ContainerAppReplicaRunningState Unknown { get; } = new ContainerAppReplicaRunningState(UnknownValue);
        /// <summary> Determines if two <see cref="ContainerAppReplicaRunningState"/> values are the same. </summary>
        public static bool operator ==(ContainerAppReplicaRunningState left, ContainerAppReplicaRunningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppReplicaRunningState"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppReplicaRunningState left, ContainerAppReplicaRunningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppReplicaRunningState"/>. </summary>
        public static implicit operator ContainerAppReplicaRunningState(string value) => new ContainerAppReplicaRunningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppReplicaRunningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppReplicaRunningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
