// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Container App container Azure Queue based scaling rule. </summary>
    public partial class ContainerAppQueueScaleRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppQueueScaleRule"/>. </summary>
        public ContainerAppQueueScaleRule()
        {
            Auth = new ChangeTrackingList<ContainerAppScaleRuleAuth>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppQueueScaleRule"/>. </summary>
        /// <param name="queueName"> Queue name. </param>
        /// <param name="queueLength"> Queue length. </param>
        /// <param name="auth"> Authentication secrets for the queue scale rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppQueueScaleRule(string queueName, int? queueLength, IList<ContainerAppScaleRuleAuth> auth, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            QueueName = queueName;
            QueueLength = queueLength;
            Auth = auth;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Queue name. </summary>
        [WirePath("queueName")]
        public string QueueName { get; set; }
        /// <summary> Queue length. </summary>
        [WirePath("queueLength")]
        public int? QueueLength { get; set; }
        /// <summary> Authentication secrets for the queue scale rule. </summary>
        [WirePath("auth")]
        public IList<ContainerAppScaleRuleAuth> Auth { get; }
    }
}
