// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> The type of probe. </summary>
    public readonly partial struct ContainerAppProbeType : IEquatable<ContainerAppProbeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppProbeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppProbeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LivenessValue = "Liveness";
        private const string ReadinessValue = "Readiness";
        private const string StartupValue = "Startup";

        /// <summary> Liveness. </summary>
        public static ContainerAppProbeType Liveness { get; } = new ContainerAppProbeType(LivenessValue);
        /// <summary> Readiness. </summary>
        public static ContainerAppProbeType Readiness { get; } = new ContainerAppProbeType(ReadinessValue);
        /// <summary> Startup. </summary>
        public static ContainerAppProbeType Startup { get; } = new ContainerAppProbeType(StartupValue);
        /// <summary> Determines if two <see cref="ContainerAppProbeType"/> values are the same. </summary>
        public static bool operator ==(ContainerAppProbeType left, ContainerAppProbeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppProbeType"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppProbeType left, ContainerAppProbeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppProbeType"/>. </summary>
        public static implicit operator ContainerAppProbeType(string value) => new ContainerAppProbeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppProbeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppProbeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
