// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppContainers.Models
{
    public partial class ContainerAppOpenIdConnectConfig : IUtf8JsonSerializable, IJsonModel<ContainerAppOpenIdConnectConfig>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerAppOpenIdConnectConfig>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerAppOpenIdConnectConfig>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppOpenIdConnectConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerAppOpenIdConnectConfig)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AuthorizationEndpoint))
            {
                writer.WritePropertyName("authorizationEndpoint"u8);
                writer.WriteStringValue(AuthorizationEndpoint);
            }
            if (Optional.IsDefined(TokenEndpoint))
            {
                writer.WritePropertyName("tokenEndpoint"u8);
                writer.WriteStringValue(TokenEndpoint);
            }
            if (Optional.IsDefined(Issuer))
            {
                writer.WritePropertyName("issuer"u8);
                writer.WriteStringValue(Issuer);
            }
            if (Optional.IsDefined(CertificationUri))
            {
                writer.WritePropertyName("certificationUri"u8);
                writer.WriteStringValue(CertificationUri.AbsoluteUri);
            }
            if (Optional.IsDefined(WellKnownOpenIdConfiguration))
            {
                writer.WritePropertyName("wellKnownOpenIdConfiguration"u8);
                writer.WriteStringValue(WellKnownOpenIdConfiguration);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ContainerAppOpenIdConnectConfig IJsonModel<ContainerAppOpenIdConnectConfig>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppOpenIdConnectConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerAppOpenIdConnectConfig)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerAppOpenIdConnectConfig(document.RootElement, options);
        }

        internal static ContainerAppOpenIdConnectConfig DeserializeContainerAppOpenIdConnectConfig(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string authorizationEndpoint = default;
            string tokenEndpoint = default;
            string issuer = default;
            Uri certificationUri = default;
            string wellKnownOpenIdConfiguration = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("authorizationEndpoint"u8))
                {
                    authorizationEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tokenEndpoint"u8))
                {
                    tokenEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("issuer"u8))
                {
                    issuer = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("certificationUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    certificationUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("wellKnownOpenIdConfiguration"u8))
                {
                    wellKnownOpenIdConfiguration = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerAppOpenIdConnectConfig(
                authorizationEndpoint,
                tokenEndpoint,
                issuer,
                certificationUri,
                wellKnownOpenIdConfiguration,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthorizationEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  authorizationEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AuthorizationEndpoint))
                {
                    builder.Append("  authorizationEndpoint: ");
                    if (AuthorizationEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AuthorizationEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AuthorizationEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TokenEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tokenEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TokenEndpoint))
                {
                    builder.Append("  tokenEndpoint: ");
                    if (TokenEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TokenEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TokenEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Issuer), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  issuer: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Issuer))
                {
                    builder.Append("  issuer: ");
                    if (Issuer.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Issuer}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Issuer}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CertificationUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  certificationUri: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CertificationUri))
                {
                    builder.Append("  certificationUri: ");
                    builder.AppendLine($"'{CertificationUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WellKnownOpenIdConfiguration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  wellKnownOpenIdConfiguration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WellKnownOpenIdConfiguration))
                {
                    builder.Append("  wellKnownOpenIdConfiguration: ");
                    if (WellKnownOpenIdConfiguration.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{WellKnownOpenIdConfiguration}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{WellKnownOpenIdConfiguration}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ContainerAppOpenIdConnectConfig>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppOpenIdConnectConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ContainerAppOpenIdConnectConfig)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerAppOpenIdConnectConfig IPersistableModel<ContainerAppOpenIdConnectConfig>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppOpenIdConnectConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerAppOpenIdConnectConfig(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerAppOpenIdConnectConfig)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerAppOpenIdConnectConfig>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
