// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> The method that should be used to authenticate the user. </summary>
    public readonly partial struct ContainerAppOpenIdConnectClientCredentialMethod : IEquatable<ContainerAppOpenIdConnectClientCredentialMethod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppOpenIdConnectClientCredentialMethod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppOpenIdConnectClientCredentialMethod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClientSecretPostValue = "ClientSecretPost";

        /// <summary> ClientSecretPost. </summary>
        public static ContainerAppOpenIdConnectClientCredentialMethod ClientSecretPost { get; } = new ContainerAppOpenIdConnectClientCredentialMethod(ClientSecretPostValue);
        /// <summary> Determines if two <see cref="ContainerAppOpenIdConnectClientCredentialMethod"/> values are the same. </summary>
        public static bool operator ==(ContainerAppOpenIdConnectClientCredentialMethod left, ContainerAppOpenIdConnectClientCredentialMethod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppOpenIdConnectClientCredentialMethod"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppOpenIdConnectClientCredentialMethod left, ContainerAppOpenIdConnectClientCredentialMethod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppOpenIdConnectClientCredentialMethod"/>. </summary>
        public static implicit operator ContainerAppOpenIdConnectClientCredentialMethod(string value) => new ContainerAppOpenIdConnectClientCredentialMethod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppOpenIdConnectClientCredentialMethod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppOpenIdConnectClientCredentialMethod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
