// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> The reason why the given name is not available. </summary>
    public readonly partial struct ContainerAppNameUnavailableReason : IEquatable<ContainerAppNameUnavailableReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppNameUnavailableReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppNameUnavailableReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AlreadyExistsValue = "AlreadyExists";

        /// <summary> Invalid. </summary>
        public static ContainerAppNameUnavailableReason Invalid { get; } = new ContainerAppNameUnavailableReason(InvalidValue);
        /// <summary> AlreadyExists. </summary>
        public static ContainerAppNameUnavailableReason AlreadyExists { get; } = new ContainerAppNameUnavailableReason(AlreadyExistsValue);
        /// <summary> Determines if two <see cref="ContainerAppNameUnavailableReason"/> values are the same. </summary>
        public static bool operator ==(ContainerAppNameUnavailableReason left, ContainerAppNameUnavailableReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppNameUnavailableReason"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppNameUnavailableReason left, ContainerAppNameUnavailableReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppNameUnavailableReason"/>. </summary>
        public static implicit operator ContainerAppNameUnavailableReason(string value) => new ContainerAppNameUnavailableReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppNameUnavailableReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppNameUnavailableReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
