// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Container Apps Job versioned application definition. Defines the desired state of an immutable revision. Any changes to this section Will result in a new revision being created. </summary>
    public partial class ContainerAppJobTemplate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppJobTemplate"/>. </summary>
        public ContainerAppJobTemplate()
        {
            InitContainers = new ChangeTrackingList<ContainerAppInitContainer>();
            Containers = new ChangeTrackingList<ContainerAppContainer>();
            Volumes = new ChangeTrackingList<ContainerAppVolume>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppJobTemplate"/>. </summary>
        /// <param name="initContainers"> List of specialized containers that run before app containers. </param>
        /// <param name="containers"> List of container definitions for the Container App. </param>
        /// <param name="volumes"> List of volume definitions for the Container App. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppJobTemplate(IList<ContainerAppInitContainer> initContainers, IList<ContainerAppContainer> containers, IList<ContainerAppVolume> volumes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InitContainers = initContainers;
            Containers = containers;
            Volumes = volumes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of specialized containers that run before app containers. </summary>
        [WirePath("initContainers")]
        public IList<ContainerAppInitContainer> InitContainers { get; }
        /// <summary> List of container definitions for the Container App. </summary>
        [WirePath("containers")]
        public IList<ContainerAppContainer> Containers { get; }
        /// <summary> List of volume definitions for the Container App. </summary>
        [WirePath("volumes")]
        public IList<ContainerAppVolume> Volumes { get; }
    }
}
