// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppContainers.Models
{
    public partial class ContainerAppJobConfiguration : IUtf8JsonSerializable, IJsonModel<ContainerAppJobConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerAppJobConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerAppJobConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppJobConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerAppJobConfiguration)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(Secrets))
            {
                writer.WritePropertyName("secrets"u8);
                writer.WriteStartArray();
                foreach (var item in Secrets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("triggerType"u8);
            writer.WriteStringValue(TriggerType.ToString());
            writer.WritePropertyName("replicaTimeout"u8);
            writer.WriteNumberValue(ReplicaTimeout);
            if (Optional.IsDefined(ReplicaRetryLimit))
            {
                writer.WritePropertyName("replicaRetryLimit"u8);
                writer.WriteNumberValue(ReplicaRetryLimit.Value);
            }
            if (Optional.IsDefined(ManualTriggerConfig))
            {
                writer.WritePropertyName("manualTriggerConfig"u8);
                writer.WriteObjectValue(ManualTriggerConfig, options);
            }
            if (Optional.IsDefined(ScheduleTriggerConfig))
            {
                writer.WritePropertyName("scheduleTriggerConfig"u8);
                writer.WriteObjectValue(ScheduleTriggerConfig, options);
            }
            if (Optional.IsDefined(EventTriggerConfig))
            {
                writer.WritePropertyName("eventTriggerConfig"u8);
                writer.WriteObjectValue(EventTriggerConfig, options);
            }
            if (Optional.IsCollectionDefined(Registries))
            {
                writer.WritePropertyName("registries"u8);
                writer.WriteStartArray();
                foreach (var item in Registries)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ContainerAppJobConfiguration IJsonModel<ContainerAppJobConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppJobConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerAppJobConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerAppJobConfiguration(document.RootElement, options);
        }

        internal static ContainerAppJobConfiguration DeserializeContainerAppJobConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<ContainerAppWritableSecret> secrets = default;
            ContainerAppJobTriggerType triggerType = default;
            int replicaTimeout = default;
            int? replicaRetryLimit = default;
            JobConfigurationManualTriggerConfig manualTriggerConfig = default;
            JobConfigurationScheduleTriggerConfig scheduleTriggerConfig = default;
            EventTriggerConfiguration eventTriggerConfig = default;
            IList<ContainerAppRegistryCredentials> registries = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("secrets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ContainerAppWritableSecret> array = new List<ContainerAppWritableSecret>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ContainerAppWritableSecret.DeserializeContainerAppWritableSecret(item, options));
                    }
                    secrets = array;
                    continue;
                }
                if (property.NameEquals("triggerType"u8))
                {
                    triggerType = new ContainerAppJobTriggerType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("replicaTimeout"u8))
                {
                    replicaTimeout = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("replicaRetryLimit"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    replicaRetryLimit = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("manualTriggerConfig"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    manualTriggerConfig = JobConfigurationManualTriggerConfig.DeserializeJobConfigurationManualTriggerConfig(property.Value, options);
                    continue;
                }
                if (property.NameEquals("scheduleTriggerConfig"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scheduleTriggerConfig = JobConfigurationScheduleTriggerConfig.DeserializeJobConfigurationScheduleTriggerConfig(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eventTriggerConfig"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    eventTriggerConfig = EventTriggerConfiguration.DeserializeEventTriggerConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("registries"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ContainerAppRegistryCredentials> array = new List<ContainerAppRegistryCredentials>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ContainerAppRegistryCredentials.DeserializeContainerAppRegistryCredentials(item, options));
                    }
                    registries = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerAppJobConfiguration(
                secrets ?? new ChangeTrackingList<ContainerAppWritableSecret>(),
                triggerType,
                replicaTimeout,
                replicaRetryLimit,
                manualTriggerConfig,
                scheduleTriggerConfig,
                eventTriggerConfig,
                registries ?? new ChangeTrackingList<ContainerAppRegistryCredentials>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Secrets), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  secrets: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Secrets))
                {
                    if (Secrets.Any())
                    {
                        builder.Append("  secrets: ");
                        builder.AppendLine("[");
                        foreach (var item in Secrets)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  secrets: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TriggerType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  triggerType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  triggerType: ");
                builder.AppendLine($"'{TriggerType.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ReplicaTimeout), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  replicaTimeout: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  replicaTimeout: ");
                builder.AppendLine($"{ReplicaTimeout}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ReplicaRetryLimit), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  replicaRetryLimit: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ReplicaRetryLimit))
                {
                    builder.Append("  replicaRetryLimit: ");
                    builder.AppendLine($"{ReplicaRetryLimit.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ManualTriggerConfig), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  manualTriggerConfig: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ManualTriggerConfig))
                {
                    builder.Append("  manualTriggerConfig: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ManualTriggerConfig, options, 2, false, "  manualTriggerConfig: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ScheduleTriggerConfig), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  scheduleTriggerConfig: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ScheduleTriggerConfig))
                {
                    builder.Append("  scheduleTriggerConfig: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ScheduleTriggerConfig, options, 2, false, "  scheduleTriggerConfig: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EventTriggerConfig), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  eventTriggerConfig: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EventTriggerConfig))
                {
                    builder.Append("  eventTriggerConfig: ");
                    BicepSerializationHelpers.AppendChildObject(builder, EventTriggerConfig, options, 2, false, "  eventTriggerConfig: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Registries), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  registries: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Registries))
                {
                    if (Registries.Any())
                    {
                        builder.Append("  registries: ");
                        builder.AppendLine("[");
                        foreach (var item in Registries)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  registries: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ContainerAppJobConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppJobConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ContainerAppJobConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerAppJobConfiguration IPersistableModel<ContainerAppJobConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppJobConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerAppJobConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerAppJobConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerAppJobConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
