// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Container App init container definition. </summary>
    public partial class ContainerAppInitContainer : ContainerAppBaseContainer
    {
        /// <summary> Initializes a new instance of <see cref="ContainerAppInitContainer"/>. </summary>
        public ContainerAppInitContainer()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppInitContainer"/>. </summary>
        /// <param name="image"> Container image tag. </param>
        /// <param name="name"> Custom container name. </param>
        /// <param name="command"> Container start command. </param>
        /// <param name="args"> Container start command arguments. </param>
        /// <param name="env"> Container environment variables. </param>
        /// <param name="resources"> Container resource requirements. </param>
        /// <param name="volumeMounts"> Container volume mounts. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppInitContainer(string image, string name, IList<string> command, IList<string> args, IList<ContainerAppEnvironmentVariable> env, AppContainerResources resources, IList<ContainerAppVolumeMount> volumeMounts, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(image, name, command, args, env, resources, volumeMounts, serializedAdditionalRawData)
        {
        }
    }
}
