// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppContainers.Models
{
    public partial class ContainerAppIngressConfiguration : IUtf8JsonSerializable, IJsonModel<ContainerAppIngressConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerAppIngressConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerAppIngressConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppIngressConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerAppIngressConfiguration)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Fqdn))
            {
                writer.WritePropertyName("fqdn"u8);
                writer.WriteStringValue(Fqdn);
            }
            if (Optional.IsDefined(External))
            {
                writer.WritePropertyName("external"u8);
                writer.WriteBooleanValue(External.Value);
            }
            if (Optional.IsDefined(TargetPort))
            {
                writer.WritePropertyName("targetPort"u8);
                writer.WriteNumberValue(TargetPort.Value);
            }
            if (Optional.IsDefined(ExposedPort))
            {
                writer.WritePropertyName("exposedPort"u8);
                writer.WriteNumberValue(ExposedPort.Value);
            }
            if (Optional.IsDefined(Transport))
            {
                writer.WritePropertyName("transport"u8);
                writer.WriteStringValue(Transport.Value.ToString());
            }
            if (Optional.IsCollectionDefined(Traffic))
            {
                writer.WritePropertyName("traffic"u8);
                writer.WriteStartArray();
                foreach (var item in Traffic)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(CustomDomains))
            {
                writer.WritePropertyName("customDomains"u8);
                writer.WriteStartArray();
                foreach (var item in CustomDomains)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(AllowInsecure))
            {
                writer.WritePropertyName("allowInsecure"u8);
                writer.WriteBooleanValue(AllowInsecure.Value);
            }
            if (Optional.IsCollectionDefined(IPSecurityRestrictions))
            {
                writer.WritePropertyName("ipSecurityRestrictions"u8);
                writer.WriteStartArray();
                foreach (var item in IPSecurityRestrictions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(StickySessions))
            {
                writer.WritePropertyName("stickySessions"u8);
                writer.WriteObjectValue(StickySessions, options);
            }
            if (Optional.IsDefined(ClientCertificateMode))
            {
                writer.WritePropertyName("clientCertificateMode"u8);
                writer.WriteStringValue(ClientCertificateMode.Value.ToString());
            }
            if (Optional.IsDefined(CorsPolicy))
            {
                writer.WritePropertyName("corsPolicy"u8);
                writer.WriteObjectValue(CorsPolicy, options);
            }
            if (Optional.IsCollectionDefined(AdditionalPortMappings))
            {
                writer.WritePropertyName("additionalPortMappings"u8);
                writer.WriteStartArray();
                foreach (var item in AdditionalPortMappings)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ContainerAppIngressConfiguration IJsonModel<ContainerAppIngressConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppIngressConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerAppIngressConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerAppIngressConfiguration(document.RootElement, options);
        }

        internal static ContainerAppIngressConfiguration DeserializeContainerAppIngressConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string fqdn = default;
            bool? external = default;
            int? targetPort = default;
            int? exposedPort = default;
            ContainerAppIngressTransportMethod? transport = default;
            IList<ContainerAppRevisionTrafficWeight> traffic = default;
            IList<ContainerAppCustomDomain> customDomains = default;
            bool? allowInsecure = default;
            IList<ContainerAppIPSecurityRestrictionRule> ipSecurityRestrictions = default;
            IngressStickySessions stickySessions = default;
            ContainerAppIngressClientCertificateMode? clientCertificateMode = default;
            ContainerAppCorsPolicy corsPolicy = default;
            IList<IngressPortMapping> additionalPortMappings = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("fqdn"u8))
                {
                    fqdn = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("external"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    external = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("targetPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("exposedPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    exposedPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("transport"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    transport = new ContainerAppIngressTransportMethod(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("traffic"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ContainerAppRevisionTrafficWeight> array = new List<ContainerAppRevisionTrafficWeight>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ContainerAppRevisionTrafficWeight.DeserializeContainerAppRevisionTrafficWeight(item, options));
                    }
                    traffic = array;
                    continue;
                }
                if (property.NameEquals("customDomains"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ContainerAppCustomDomain> array = new List<ContainerAppCustomDomain>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ContainerAppCustomDomain.DeserializeContainerAppCustomDomain(item, options));
                    }
                    customDomains = array;
                    continue;
                }
                if (property.NameEquals("allowInsecure"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allowInsecure = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("ipSecurityRestrictions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ContainerAppIPSecurityRestrictionRule> array = new List<ContainerAppIPSecurityRestrictionRule>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ContainerAppIPSecurityRestrictionRule.DeserializeContainerAppIPSecurityRestrictionRule(item, options));
                    }
                    ipSecurityRestrictions = array;
                    continue;
                }
                if (property.NameEquals("stickySessions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stickySessions = IngressStickySessions.DeserializeIngressStickySessions(property.Value, options);
                    continue;
                }
                if (property.NameEquals("clientCertificateMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    clientCertificateMode = new ContainerAppIngressClientCertificateMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("corsPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    corsPolicy = ContainerAppCorsPolicy.DeserializeContainerAppCorsPolicy(property.Value, options);
                    continue;
                }
                if (property.NameEquals("additionalPortMappings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IngressPortMapping> array = new List<IngressPortMapping>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(IngressPortMapping.DeserializeIngressPortMapping(item, options));
                    }
                    additionalPortMappings = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerAppIngressConfiguration(
                fqdn,
                external,
                targetPort,
                exposedPort,
                transport,
                traffic ?? new ChangeTrackingList<ContainerAppRevisionTrafficWeight>(),
                customDomains ?? new ChangeTrackingList<ContainerAppCustomDomain>(),
                allowInsecure,
                ipSecurityRestrictions ?? new ChangeTrackingList<ContainerAppIPSecurityRestrictionRule>(),
                stickySessions,
                clientCertificateMode,
                corsPolicy,
                additionalPortMappings ?? new ChangeTrackingList<IngressPortMapping>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Fqdn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fqdn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Fqdn))
                {
                    builder.Append("  fqdn: ");
                    if (Fqdn.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Fqdn}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Fqdn}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(External), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  external: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(External))
                {
                    builder.Append("  external: ");
                    var boolValue = External.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TargetPort), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  targetPort: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TargetPort))
                {
                    builder.Append("  targetPort: ");
                    builder.AppendLine($"{TargetPort.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExposedPort), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  exposedPort: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExposedPort))
                {
                    builder.Append("  exposedPort: ");
                    builder.AppendLine($"{ExposedPort.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Transport), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  transport: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Transport))
                {
                    builder.Append("  transport: ");
                    builder.AppendLine($"'{Transport.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Traffic), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  traffic: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Traffic))
                {
                    if (Traffic.Any())
                    {
                        builder.Append("  traffic: ");
                        builder.AppendLine("[");
                        foreach (var item in Traffic)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  traffic: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomDomains), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  customDomains: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(CustomDomains))
                {
                    if (CustomDomains.Any())
                    {
                        builder.Append("  customDomains: ");
                        builder.AppendLine("[");
                        foreach (var item in CustomDomains)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  customDomains: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AllowInsecure), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  allowInsecure: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AllowInsecure))
                {
                    builder.Append("  allowInsecure: ");
                    var boolValue = AllowInsecure.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IPSecurityRestrictions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ipSecurityRestrictions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(IPSecurityRestrictions))
                {
                    if (IPSecurityRestrictions.Any())
                    {
                        builder.Append("  ipSecurityRestrictions: ");
                        builder.AppendLine("[");
                        foreach (var item in IPSecurityRestrictions)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  ipSecurityRestrictions: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("StickySessionsAffinity", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  stickySessions: ");
                builder.AppendLine("{");
                builder.Append("    affinity: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(StickySessions))
                {
                    builder.Append("  stickySessions: ");
                    BicepSerializationHelpers.AppendChildObject(builder, StickySessions, options, 2, false, "  stickySessions: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClientCertificateMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clientCertificateMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClientCertificateMode))
                {
                    builder.Append("  clientCertificateMode: ");
                    builder.AppendLine($"'{ClientCertificateMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CorsPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  corsPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CorsPolicy))
                {
                    builder.Append("  corsPolicy: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CorsPolicy, options, 2, false, "  corsPolicy: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AdditionalPortMappings), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  additionalPortMappings: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AdditionalPortMappings))
                {
                    if (AdditionalPortMappings.Any())
                    {
                        builder.Append("  additionalPortMappings: ");
                        builder.AppendLine("[");
                        foreach (var item in AdditionalPortMappings)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  additionalPortMappings: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ContainerAppIngressConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppIngressConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ContainerAppIngressConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerAppIngressConfiguration IPersistableModel<ContainerAppIngressConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppIngressConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerAppIngressConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerAppIngressConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerAppIngressConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
