// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate. </summary>
    public readonly partial struct ContainerAppIngressClientCertificateMode : IEquatable<ContainerAppIngressClientCertificateMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppIngressClientCertificateMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppIngressClientCertificateMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IgnoreValue = "ignore";
        private const string AcceptValue = "accept";
        private const string RequireValue = "require";

        /// <summary> ignore. </summary>
        public static ContainerAppIngressClientCertificateMode Ignore { get; } = new ContainerAppIngressClientCertificateMode(IgnoreValue);
        /// <summary> accept. </summary>
        public static ContainerAppIngressClientCertificateMode Accept { get; } = new ContainerAppIngressClientCertificateMode(AcceptValue);
        /// <summary> require. </summary>
        public static ContainerAppIngressClientCertificateMode Require { get; } = new ContainerAppIngressClientCertificateMode(RequireValue);
        /// <summary> Determines if two <see cref="ContainerAppIngressClientCertificateMode"/> values are the same. </summary>
        public static bool operator ==(ContainerAppIngressClientCertificateMode left, ContainerAppIngressClientCertificateMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppIngressClientCertificateMode"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppIngressClientCertificateMode left, ContainerAppIngressClientCertificateMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppIngressClientCertificateMode"/>. </summary>
        public static implicit operator ContainerAppIngressClientCertificateMode(string value) => new ContainerAppIngressClientCertificateMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppIngressClientCertificateMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppIngressClientCertificateMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
