// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny. </summary>
    public readonly partial struct ContainerAppIPRuleAction : IEquatable<ContainerAppIPRuleAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppIPRuleAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppIPRuleAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenyValue = "Deny";

        /// <summary> Allow. </summary>
        public static ContainerAppIPRuleAction Allow { get; } = new ContainerAppIPRuleAction(AllowValue);
        /// <summary> Deny. </summary>
        public static ContainerAppIPRuleAction Deny { get; } = new ContainerAppIPRuleAction(DenyValue);
        /// <summary> Determines if two <see cref="ContainerAppIPRuleAction"/> values are the same. </summary>
        public static bool operator ==(ContainerAppIPRuleAction left, ContainerAppIPRuleAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppIPRuleAction"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppIPRuleAction left, ContainerAppIPRuleAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppIPRuleAction"/>. </summary>
        public static implicit operator ContainerAppIPRuleAction(string value) => new ContainerAppIPRuleAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppIPRuleAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppIPRuleAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
