// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Scheme to use for connecting to the host. Defaults to HTTP. </summary>
    public readonly partial struct ContainerAppHttpScheme : IEquatable<ContainerAppHttpScheme>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppHttpScheme"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppHttpScheme(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpValue = "HTTP";
        private const string HttpsValue = "HTTPS";

        /// <summary> HTTP. </summary>
        public static ContainerAppHttpScheme Http { get; } = new ContainerAppHttpScheme(HttpValue);
        /// <summary> HTTPS. </summary>
        public static ContainerAppHttpScheme Https { get; } = new ContainerAppHttpScheme(HttpsValue);
        /// <summary> Determines if two <see cref="ContainerAppHttpScheme"/> values are the same. </summary>
        public static bool operator ==(ContainerAppHttpScheme left, ContainerAppHttpScheme right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppHttpScheme"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppHttpScheme left, ContainerAppHttpScheme right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppHttpScheme"/>. </summary>
        public static implicit operator ContainerAppHttpScheme(string value) => new ContainerAppHttpScheme(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppHttpScheme other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppHttpScheme other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
