// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.AppContainers.Models
{
    internal static partial class ContainerAppForwardProxyConventionExtensions
    {
        public static string ToSerialString(this ContainerAppForwardProxyConvention value) => value switch
        {
            ContainerAppForwardProxyConvention.NoProxy => "NoProxy",
            ContainerAppForwardProxyConvention.Standard => "Standard",
            ContainerAppForwardProxyConvention.Custom => "Custom",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ContainerAppForwardProxyConvention value.")
        };

        public static ContainerAppForwardProxyConvention ToContainerAppForwardProxyConvention(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NoProxy")) return ContainerAppForwardProxyConvention.NoProxy;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard")) return ContainerAppForwardProxyConvention.Standard;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Custom")) return ContainerAppForwardProxyConvention.Custom;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ContainerAppForwardProxyConvention value.");
        }
    }
}
