// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Container App container environment variable. </summary>
    public partial class ContainerAppEnvironmentVariable
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppEnvironmentVariable"/>. </summary>
        public ContainerAppEnvironmentVariable()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppEnvironmentVariable"/>. </summary>
        /// <param name="name"> Environment variable name. </param>
        /// <param name="value"> Non-secret environment variable value. </param>
        /// <param name="secretRef"> Name of the Container App secret from which to pull the environment variable value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppEnvironmentVariable(string name, string value, string secretRef, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Value = value;
            SecretRef = secretRef;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Environment variable name. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Non-secret environment variable value. </summary>
        [WirePath("value")]
        public string Value { get; set; }
        /// <summary> Name of the Container App secret from which to pull the environment variable value. </summary>
        [WirePath("secretRef")]
        public string SecretRef { get; set; }
    }
}
