// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Provisioning state of the Environment. </summary>
    public readonly partial struct ContainerAppEnvironmentProvisioningState : IEquatable<ContainerAppEnvironmentProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppEnvironmentProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppEnvironmentProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string WaitingValue = "Waiting";
        private const string InitializationInProgressValue = "InitializationInProgress";
        private const string InfrastructureSetupInProgressValue = "InfrastructureSetupInProgress";
        private const string InfrastructureSetupCompleteValue = "InfrastructureSetupComplete";
        private const string ScheduledForDeleteValue = "ScheduledForDelete";
        private const string UpgradeRequestedValue = "UpgradeRequested";
        private const string UpgradeFailedValue = "UpgradeFailed";

        /// <summary> Succeeded. </summary>
        public static ContainerAppEnvironmentProvisioningState Succeeded { get; } = new ContainerAppEnvironmentProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ContainerAppEnvironmentProvisioningState Failed { get; } = new ContainerAppEnvironmentProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static ContainerAppEnvironmentProvisioningState Canceled { get; } = new ContainerAppEnvironmentProvisioningState(CanceledValue);
        /// <summary> Waiting. </summary>
        public static ContainerAppEnvironmentProvisioningState Waiting { get; } = new ContainerAppEnvironmentProvisioningState(WaitingValue);
        /// <summary> InitializationInProgress. </summary>
        public static ContainerAppEnvironmentProvisioningState InitializationInProgress { get; } = new ContainerAppEnvironmentProvisioningState(InitializationInProgressValue);
        /// <summary> InfrastructureSetupInProgress. </summary>
        public static ContainerAppEnvironmentProvisioningState InfrastructureSetupInProgress { get; } = new ContainerAppEnvironmentProvisioningState(InfrastructureSetupInProgressValue);
        /// <summary> InfrastructureSetupComplete. </summary>
        public static ContainerAppEnvironmentProvisioningState InfrastructureSetupComplete { get; } = new ContainerAppEnvironmentProvisioningState(InfrastructureSetupCompleteValue);
        /// <summary> ScheduledForDelete. </summary>
        public static ContainerAppEnvironmentProvisioningState ScheduledForDelete { get; } = new ContainerAppEnvironmentProvisioningState(ScheduledForDeleteValue);
        /// <summary> UpgradeRequested. </summary>
        public static ContainerAppEnvironmentProvisioningState UpgradeRequested { get; } = new ContainerAppEnvironmentProvisioningState(UpgradeRequestedValue);
        /// <summary> UpgradeFailed. </summary>
        public static ContainerAppEnvironmentProvisioningState UpgradeFailed { get; } = new ContainerAppEnvironmentProvisioningState(UpgradeFailedValue);
        /// <summary> Determines if two <see cref="ContainerAppEnvironmentProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ContainerAppEnvironmentProvisioningState left, ContainerAppEnvironmentProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppEnvironmentProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppEnvironmentProvisioningState left, ContainerAppEnvironmentProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppEnvironmentProvisioningState"/>. </summary>
        public static implicit operator ContainerAppEnvironmentProvisioningState(string value) => new ContainerAppEnvironmentProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppEnvironmentProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppEnvironmentProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
