// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.AppContainers.Models
{
    internal static partial class ContainerAppDnsVerificationTestResultExtensions
    {
        public static string ToSerialString(this ContainerAppDnsVerificationTestResult value) => value switch
        {
            ContainerAppDnsVerificationTestResult.Passed => "Passed",
            ContainerAppDnsVerificationTestResult.Failed => "Failed",
            ContainerAppDnsVerificationTestResult.Skipped => "Skipped",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ContainerAppDnsVerificationTestResult value.")
        };

        public static ContainerAppDnsVerificationTestResult ToContainerAppDnsVerificationTestResult(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Passed")) return ContainerAppDnsVerificationTestResult.Passed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return ContainerAppDnsVerificationTestResult.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Skipped")) return ContainerAppDnsVerificationTestResult.Skipped;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ContainerAppDnsVerificationTestResult value.");
        }
    }
}
