// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Support topic information. </summary>
    public partial class ContainerAppDiagnosticSupportTopic
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppDiagnosticSupportTopic"/>. </summary>
        public ContainerAppDiagnosticSupportTopic()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppDiagnosticSupportTopic"/>. </summary>
        /// <param name="id"> Unique topic identifier. </param>
        /// <param name="pesId"> PES identifier. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppDiagnosticSupportTopic(string id, string pesId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            PesId = pesId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Unique topic identifier. </summary>
        [WirePath("id")]
        public string Id { get; }
        /// <summary> PES identifier. </summary>
        [WirePath("pesId")]
        public string PesId { get; }
    }
}
