// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Rendering details of a diagnostics table. </summary>
    public partial class ContainerAppDiagnosticRendering
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppDiagnosticRendering"/>. </summary>
        public ContainerAppDiagnosticRendering()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppDiagnosticRendering"/>. </summary>
        /// <param name="diagnosticRenderingType"> Rendering type. </param>
        /// <param name="title"> Title of the table. </param>
        /// <param name="description"> Description of the table. </param>
        /// <param name="isVisible"> Flag if the table should be rendered. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppDiagnosticRendering(int? diagnosticRenderingType, string title, string description, bool? isVisible, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DiagnosticRenderingType = diagnosticRenderingType;
            Title = title;
            Description = description;
            IsVisible = isVisible;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Rendering type. </summary>
        [WirePath("type")]
        public int? DiagnosticRenderingType { get; set; }
        /// <summary> Title of the table. </summary>
        [WirePath("title")]
        public string Title { get; set; }
        /// <summary> Description of the table. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> Flag if the table should be rendered. </summary>
        [WirePath("isVisible")]
        public bool? IsVisible { get; set; }
    }
}
