// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Diagnostics data table. </summary>
    public partial class ContainerAppDiagnosticDataTableResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppDiagnosticDataTableResult"/>. </summary>
        public ContainerAppDiagnosticDataTableResult()
        {
            Columns = new ChangeTrackingList<ContainerAppDiagnosticDataColumn>();
            Rows = new ChangeTrackingList<BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppDiagnosticDataTableResult"/>. </summary>
        /// <param name="tableName"> Table name. </param>
        /// <param name="columns"> Columns in the table. </param>
        /// <param name="rows"> Rows in the table. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppDiagnosticDataTableResult(string tableName, IList<ContainerAppDiagnosticDataColumn> columns, IList<BinaryData> rows, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TableName = tableName;
            Columns = columns;
            Rows = rows;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Table name. </summary>
        [WirePath("tableName")]
        public string TableName { get; set; }
        /// <summary> Columns in the table. </summary>
        [WirePath("columns")]
        public IList<ContainerAppDiagnosticDataColumn> Columns { get; }
        /// <summary>
        /// Rows in the table
        /// <para>
        /// To assign an object to the element of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("rows")]
        public IList<BinaryData> Rows { get; }
    }
}
