// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Dapr component metadata. </summary>
    public partial class ContainerAppDaprMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppDaprMetadata"/>. </summary>
        public ContainerAppDaprMetadata()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppDaprMetadata"/>. </summary>
        /// <param name="name"> Metadata property name. </param>
        /// <param name="value"> Metadata property value. </param>
        /// <param name="secretRef"> Name of the Dapr Component secret from which to pull the metadata property value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppDaprMetadata(string name, string value, string secretRef, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Value = value;
            SecretRef = secretRef;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Metadata property name. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Metadata property value. </summary>
        [WirePath("value")]
        public string Value { get; set; }
        /// <summary> Name of the Dapr Component secret from which to pull the metadata property value. </summary>
        [WirePath("secretRef")]
        public string SecretRef { get; set; }
    }
}
