// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info. </summary>
    public readonly partial struct ContainerAppDaprLogLevel : IEquatable<ContainerAppDaprLogLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppDaprLogLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppDaprLogLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InfoValue = "info";
        private const string DebugValue = "debug";
        private const string WarnValue = "warn";
        private const string ErrorValue = "error";

        /// <summary> info. </summary>
        public static ContainerAppDaprLogLevel Info { get; } = new ContainerAppDaprLogLevel(InfoValue);
        /// <summary> debug. </summary>
        public static ContainerAppDaprLogLevel Debug { get; } = new ContainerAppDaprLogLevel(DebugValue);
        /// <summary> warn. </summary>
        public static ContainerAppDaprLogLevel Warn { get; } = new ContainerAppDaprLogLevel(WarnValue);
        /// <summary> error. </summary>
        public static ContainerAppDaprLogLevel Error { get; } = new ContainerAppDaprLogLevel(ErrorValue);
        /// <summary> Determines if two <see cref="ContainerAppDaprLogLevel"/> values are the same. </summary>
        public static bool operator ==(ContainerAppDaprLogLevel left, ContainerAppDaprLogLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppDaprLogLevel"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppDaprLogLevel left, ContainerAppDaprLogLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppDaprLogLevel"/>. </summary>
        public static implicit operator ContainerAppDaprLogLevel(string value) => new ContainerAppDaprLogLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppDaprLogLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppDaprLogLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
