// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Container App Dapr configuration. </summary>
    public partial class ContainerAppDaprConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppDaprConfiguration"/>. </summary>
        public ContainerAppDaprConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppDaprConfiguration"/>. </summary>
        /// <param name="isEnabled"> Boolean indicating if the Dapr side car is enabled. </param>
        /// <param name="appId"> Dapr application identifier. </param>
        /// <param name="appProtocol"> Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http. </param>
        /// <param name="appPort"> Tells Dapr which port your application is listening on. </param>
        /// <param name="httpReadBufferSize"> Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB. </param>
        /// <param name="httpMaxRequestSize"> Increasing max size of request body http and grpc servers parameter in MB to handle uploading of big files. Default is 4 MB. </param>
        /// <param name="logLevel"> Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info. </param>
        /// <param name="isApiLoggingEnabled"> Enables API logging for the Dapr sidecar. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppDaprConfiguration(bool? isEnabled, string appId, ContainerAppProtocol? appProtocol, int? appPort, int? httpReadBufferSize, int? httpMaxRequestSize, ContainerAppDaprLogLevel? logLevel, bool? isApiLoggingEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            AppId = appId;
            AppProtocol = appProtocol;
            AppPort = appPort;
            HttpReadBufferSize = httpReadBufferSize;
            HttpMaxRequestSize = httpMaxRequestSize;
            LogLevel = logLevel;
            IsApiLoggingEnabled = isApiLoggingEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Boolean indicating if the Dapr side car is enabled. </summary>
        [WirePath("enabled")]
        public bool? IsEnabled { get; set; }
        /// <summary> Dapr application identifier. </summary>
        [WirePath("appId")]
        public string AppId { get; set; }
        /// <summary> Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http. </summary>
        [WirePath("appProtocol")]
        public ContainerAppProtocol? AppProtocol { get; set; }
        /// <summary> Tells Dapr which port your application is listening on. </summary>
        [WirePath("appPort")]
        public int? AppPort { get; set; }
        /// <summary> Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB. </summary>
        [WirePath("httpReadBufferSize")]
        public int? HttpReadBufferSize { get; set; }
        /// <summary> Increasing max size of request body http and grpc servers parameter in MB to handle uploading of big files. Default is 4 MB. </summary>
        [WirePath("httpMaxRequestSize")]
        public int? HttpMaxRequestSize { get; set; }
        /// <summary> Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info. </summary>
        [WirePath("logLevel")]
        public ContainerAppDaprLogLevel? LogLevel { get; set; }
        /// <summary> Enables API logging for the Dapr sidecar. </summary>
        [WirePath("enableApiLogging")]
        public bool? IsApiLoggingEnabled { get; set; }
    }
}
