// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppContainers.Models
{
    public partial class ContainerAppDaprConfiguration : IUtf8JsonSerializable, IJsonModel<ContainerAppDaprConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerAppDaprConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerAppDaprConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppDaprConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerAppDaprConfiguration)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(IsEnabled))
            {
                writer.WritePropertyName("enabled"u8);
                writer.WriteBooleanValue(IsEnabled.Value);
            }
            if (Optional.IsDefined(AppId))
            {
                writer.WritePropertyName("appId"u8);
                writer.WriteStringValue(AppId);
            }
            if (Optional.IsDefined(AppProtocol))
            {
                writer.WritePropertyName("appProtocol"u8);
                writer.WriteStringValue(AppProtocol.Value.ToString());
            }
            if (Optional.IsDefined(AppPort))
            {
                writer.WritePropertyName("appPort"u8);
                writer.WriteNumberValue(AppPort.Value);
            }
            if (Optional.IsDefined(HttpReadBufferSize))
            {
                writer.WritePropertyName("httpReadBufferSize"u8);
                writer.WriteNumberValue(HttpReadBufferSize.Value);
            }
            if (Optional.IsDefined(HttpMaxRequestSize))
            {
                writer.WritePropertyName("httpMaxRequestSize"u8);
                writer.WriteNumberValue(HttpMaxRequestSize.Value);
            }
            if (Optional.IsDefined(LogLevel))
            {
                writer.WritePropertyName("logLevel"u8);
                writer.WriteStringValue(LogLevel.Value.ToString());
            }
            if (Optional.IsDefined(IsApiLoggingEnabled))
            {
                writer.WritePropertyName("enableApiLogging"u8);
                writer.WriteBooleanValue(IsApiLoggingEnabled.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ContainerAppDaprConfiguration IJsonModel<ContainerAppDaprConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppDaprConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerAppDaprConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerAppDaprConfiguration(document.RootElement, options);
        }

        internal static ContainerAppDaprConfiguration DeserializeContainerAppDaprConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? enabled = default;
            string appId = default;
            ContainerAppProtocol? appProtocol = default;
            int? appPort = default;
            int? httpReadBufferSize = default;
            int? httpMaxRequestSize = default;
            ContainerAppDaprLogLevel? logLevel = default;
            bool? enableApiLogging = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("enabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("appId"u8))
                {
                    appId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("appProtocol"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    appProtocol = new ContainerAppProtocol(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("appPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    appPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("httpReadBufferSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    httpReadBufferSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("httpMaxRequestSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    httpMaxRequestSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("logLevel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    logLevel = new ContainerAppDaprLogLevel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("enableApiLogging"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableApiLogging = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerAppDaprConfiguration(
                enabled,
                appId,
                appProtocol,
                appPort,
                httpReadBufferSize,
                httpMaxRequestSize,
                logLevel,
                enableApiLogging,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enabled: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsEnabled))
                {
                    builder.Append("  enabled: ");
                    var boolValue = IsEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AppId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  appId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AppId))
                {
                    builder.Append("  appId: ");
                    if (AppId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AppId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AppId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AppProtocol), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  appProtocol: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AppProtocol))
                {
                    builder.Append("  appProtocol: ");
                    builder.AppendLine($"'{AppProtocol.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AppPort), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  appPort: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AppPort))
                {
                    builder.Append("  appPort: ");
                    builder.AppendLine($"{AppPort.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HttpReadBufferSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  httpReadBufferSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HttpReadBufferSize))
                {
                    builder.Append("  httpReadBufferSize: ");
                    builder.AppendLine($"{HttpReadBufferSize.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HttpMaxRequestSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  httpMaxRequestSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HttpMaxRequestSize))
                {
                    builder.Append("  httpMaxRequestSize: ");
                    builder.AppendLine($"{HttpMaxRequestSize.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LogLevel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  logLevel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LogLevel))
                {
                    builder.Append("  logLevel: ");
                    builder.AppendLine($"'{LogLevel.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsApiLoggingEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enableApiLogging: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsApiLoggingEnabled))
                {
                    builder.Append("  enableApiLogging: ");
                    var boolValue = IsApiLoggingEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ContainerAppDaprConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppDaprConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ContainerAppDaprConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerAppDaprConfiguration IPersistableModel<ContainerAppDaprConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppDaprConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerAppDaprConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerAppDaprConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerAppDaprConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
