// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Custom Domain binding type. </summary>
    public readonly partial struct ContainerAppCustomDomainBindingType : IEquatable<ContainerAppCustomDomainBindingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppCustomDomainBindingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppCustomDomainBindingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string SniEnabledValue = "SniEnabled";

        /// <summary> Disabled. </summary>
        public static ContainerAppCustomDomainBindingType Disabled { get; } = new ContainerAppCustomDomainBindingType(DisabledValue);
        /// <summary> SniEnabled. </summary>
        public static ContainerAppCustomDomainBindingType SniEnabled { get; } = new ContainerAppCustomDomainBindingType(SniEnabledValue);
        /// <summary> Determines if two <see cref="ContainerAppCustomDomainBindingType"/> values are the same. </summary>
        public static bool operator ==(ContainerAppCustomDomainBindingType left, ContainerAppCustomDomainBindingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppCustomDomainBindingType"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppCustomDomainBindingType left, ContainerAppCustomDomainBindingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppCustomDomainBindingType"/>. </summary>
        public static implicit operator ContainerAppCustomDomainBindingType(string value) => new ContainerAppCustomDomainBindingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppCustomDomainBindingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppCustomDomainBindingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
