// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> The configuration settings of the session cookie's expiration. </summary>
    public partial class ContainerAppCookieExpiration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppCookieExpiration"/>. </summary>
        public ContainerAppCookieExpiration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppCookieExpiration"/>. </summary>
        /// <param name="convention"> The convention used when determining the session cookie's expiration. </param>
        /// <param name="timeToExpiration"> The time after the request is made when the session cookie should expire. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppCookieExpiration(ContainerAppCookieExpirationConvention? convention, string timeToExpiration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Convention = convention;
            TimeToExpiration = timeToExpiration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The convention used when determining the session cookie's expiration. </summary>
        [WirePath("convention")]
        public ContainerAppCookieExpirationConvention? Convention { get; set; }
        /// <summary> The time after the request is made when the session cookie should expire. </summary>
        [WirePath("timeToExpiration")]
        public string TimeToExpiration { get; set; }
    }
}
