// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Current running state of the container. </summary>
    public readonly partial struct ContainerAppContainerRunningState : IEquatable<ContainerAppContainerRunningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppContainerRunningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppContainerRunningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "Running";
        private const string TerminatedValue = "Terminated";
        private const string WaitingValue = "Waiting";

        /// <summary> Running. </summary>
        public static ContainerAppContainerRunningState Running { get; } = new ContainerAppContainerRunningState(RunningValue);
        /// <summary> Terminated. </summary>
        public static ContainerAppContainerRunningState Terminated { get; } = new ContainerAppContainerRunningState(TerminatedValue);
        /// <summary> Waiting. </summary>
        public static ContainerAppContainerRunningState Waiting { get; } = new ContainerAppContainerRunningState(WaitingValue);
        /// <summary> Determines if two <see cref="ContainerAppContainerRunningState"/> values are the same. </summary>
        public static bool operator ==(ContainerAppContainerRunningState left, ContainerAppContainerRunningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppContainerRunningState"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppContainerRunningState left, ContainerAppContainerRunningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppContainerRunningState"/>. </summary>
        public static implicit operator ContainerAppContainerRunningState(string value) => new ContainerAppContainerRunningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppContainerRunningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppContainerRunningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
