// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Provisioning state of the Kubernetes Environment. </summary>
    public readonly partial struct ContainerAppConnectedEnvironmentProvisioningState : IEquatable<ContainerAppConnectedEnvironmentProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppConnectedEnvironmentProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppConnectedEnvironmentProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string WaitingValue = "Waiting";
        private const string InitializationInProgressValue = "InitializationInProgress";
        private const string InfrastructureSetupInProgressValue = "InfrastructureSetupInProgress";
        private const string InfrastructureSetupCompleteValue = "InfrastructureSetupComplete";
        private const string ScheduledForDeleteValue = "ScheduledForDelete";

        /// <summary> Succeeded. </summary>
        public static ContainerAppConnectedEnvironmentProvisioningState Succeeded { get; } = new ContainerAppConnectedEnvironmentProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ContainerAppConnectedEnvironmentProvisioningState Failed { get; } = new ContainerAppConnectedEnvironmentProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static ContainerAppConnectedEnvironmentProvisioningState Canceled { get; } = new ContainerAppConnectedEnvironmentProvisioningState(CanceledValue);
        /// <summary> Waiting. </summary>
        public static ContainerAppConnectedEnvironmentProvisioningState Waiting { get; } = new ContainerAppConnectedEnvironmentProvisioningState(WaitingValue);
        /// <summary> InitializationInProgress. </summary>
        public static ContainerAppConnectedEnvironmentProvisioningState InitializationInProgress { get; } = new ContainerAppConnectedEnvironmentProvisioningState(InitializationInProgressValue);
        /// <summary> InfrastructureSetupInProgress. </summary>
        public static ContainerAppConnectedEnvironmentProvisioningState InfrastructureSetupInProgress { get; } = new ContainerAppConnectedEnvironmentProvisioningState(InfrastructureSetupInProgressValue);
        /// <summary> InfrastructureSetupComplete. </summary>
        public static ContainerAppConnectedEnvironmentProvisioningState InfrastructureSetupComplete { get; } = new ContainerAppConnectedEnvironmentProvisioningState(InfrastructureSetupCompleteValue);
        /// <summary> ScheduledForDelete. </summary>
        public static ContainerAppConnectedEnvironmentProvisioningState ScheduledForDelete { get; } = new ContainerAppConnectedEnvironmentProvisioningState(ScheduledForDeleteValue);
        /// <summary> Determines if two <see cref="ContainerAppConnectedEnvironmentProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ContainerAppConnectedEnvironmentProvisioningState left, ContainerAppConnectedEnvironmentProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppConnectedEnvironmentProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppConnectedEnvironmentProvisioningState left, ContainerAppConnectedEnvironmentProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppConnectedEnvironmentProvisioningState"/>. </summary>
        public static implicit operator ContainerAppConnectedEnvironmentProvisioningState(string value) => new ContainerAppConnectedEnvironmentProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppConnectedEnvironmentProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppConnectedEnvironmentProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
