// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> The configuration settings of the app registration for providers that have client ids and client secrets. </summary>
    public partial class ContainerAppClientRegistration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppClientRegistration"/>. </summary>
        public ContainerAppClientRegistration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppClientRegistration"/>. </summary>
        /// <param name="clientId"> The Client ID of the app used for login. </param>
        /// <param name="clientSecretSettingName"> The app setting name that contains the client secret. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppClientRegistration(string clientId, string clientSecretSettingName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClientId = clientId;
            ClientSecretSettingName = clientSecretSettingName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Client ID of the app used for login. </summary>
        [WirePath("clientId")]
        public string ClientId { get; set; }
        /// <summary> The app setting name that contains the client secret. </summary>
        [WirePath("clientSecretSettingName")]
        public string ClientSecretSettingName { get; set; }
    }
}
