// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Revision resource specific properties. </summary>
    public partial class ContainerAppBillingMeterProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppBillingMeterProperties"/>. </summary>
        public ContainerAppBillingMeterProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppBillingMeterProperties"/>. </summary>
        /// <param name="workloadProfileCategory"> Used to categorize billing meters. </param>
        /// <param name="meterType"> Billing meter type. </param>
        /// <param name="displayName"> The everyday name of the billing meter. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppBillingMeterProperties(string workloadProfileCategory, string meterType, string displayName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WorkloadProfileCategory = workloadProfileCategory;
            MeterType = meterType;
            DisplayName = displayName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Used to categorize billing meters. </summary>
        [WirePath("category")]
        public string WorkloadProfileCategory { get; set; }
        /// <summary> Billing meter type. </summary>
        [WirePath("meterType")]
        public string MeterType { get; set; }
        /// <summary> The everyday name of the billing meter. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; set; }
    }
}
