// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Revision resource specific properties. </summary>
    public partial class ContainerAppAvailableWorkloadProfileProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppAvailableWorkloadProfileProperties"/>. </summary>
        public ContainerAppAvailableWorkloadProfileProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppAvailableWorkloadProfileProperties"/>. </summary>
        /// <param name="category"> Used to categorize workload profiles. </param>
        /// <param name="applicability"> indicates whether the profile is default for the location. </param>
        /// <param name="cores"> Number of cores in CPU. </param>
        /// <param name="memoryInGiB"> Memory in GiB. </param>
        /// <param name="gpus"> Number of GPUs. </param>
        /// <param name="displayName"> The everyday name of the workload profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppAvailableWorkloadProfileProperties(string category, ContainerAppAvailableWorkloadProfileApplicability? applicability, int? cores, int? memoryInGiB, int? gpus, string displayName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Category = category;
            Applicability = applicability;
            Cores = cores;
            MemoryInGiB = memoryInGiB;
            Gpus = gpus;
            DisplayName = displayName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Used to categorize workload profiles. </summary>
        [WirePath("category")]
        public string Category { get; set; }
        /// <summary> indicates whether the profile is default for the location. </summary>
        [WirePath("applicability")]
        public ContainerAppAvailableWorkloadProfileApplicability? Applicability { get; set; }
        /// <summary> Number of cores in CPU. </summary>
        [WirePath("cores")]
        public int? Cores { get; set; }
        /// <summary> Memory in GiB. </summary>
        [WirePath("memoryGiB")]
        public int? MemoryInGiB { get; set; }
        /// <summary> Number of GPUs. </summary>
        [WirePath("gpus")]
        public int? Gpus { get; set; }
        /// <summary> The everyday name of the workload profile. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; set; }
    }
}
