// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> indicates whether the profile is default for the location. </summary>
    public readonly partial struct ContainerAppAvailableWorkloadProfileApplicability : IEquatable<ContainerAppAvailableWorkloadProfileApplicability>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppAvailableWorkloadProfileApplicability"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppAvailableWorkloadProfileApplicability(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LocationDefaultValue = "LocationDefault";
        private const string CustomValue = "Custom";

        /// <summary> LocationDefault. </summary>
        public static ContainerAppAvailableWorkloadProfileApplicability LocationDefault { get; } = new ContainerAppAvailableWorkloadProfileApplicability(LocationDefaultValue);
        /// <summary> Custom. </summary>
        public static ContainerAppAvailableWorkloadProfileApplicability Custom { get; } = new ContainerAppAvailableWorkloadProfileApplicability(CustomValue);
        /// <summary> Determines if two <see cref="ContainerAppAvailableWorkloadProfileApplicability"/> values are the same. </summary>
        public static bool operator ==(ContainerAppAvailableWorkloadProfileApplicability left, ContainerAppAvailableWorkloadProfileApplicability right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppAvailableWorkloadProfileApplicability"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppAvailableWorkloadProfileApplicability left, ContainerAppAvailableWorkloadProfileApplicability right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerAppAvailableWorkloadProfileApplicability"/>. </summary>
        public static implicit operator ContainerAppAvailableWorkloadProfileApplicability(string value) => new ContainerAppAvailableWorkloadProfileApplicability(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppAvailableWorkloadProfileApplicability other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppAvailableWorkloadProfileApplicability other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
