// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppContainers
{
    internal class ContainerAppSourceControlOperationSource : IOperationSource<ContainerAppSourceControlResource>
    {
        private readonly ArmClient _client;

        internal ContainerAppSourceControlOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerAppSourceControlResource IOperationSource<ContainerAppSourceControlResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerAppSourceControlData.DeserializeContainerAppSourceControlData(document.RootElement);
            return new ContainerAppSourceControlResource(_client, data);
        }

        async ValueTask<ContainerAppSourceControlResource> IOperationSource<ContainerAppSourceControlResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerAppSourceControlData.DeserializeContainerAppSourceControlData(document.RootElement);
            return new ContainerAppSourceControlResource(_client, data);
        }
    }
}
