// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppContainers
{
    internal class ContainerAppManagedEnvironmentOperationSource : IOperationSource<ContainerAppManagedEnvironmentResource>
    {
        private readonly ArmClient _client;

        internal ContainerAppManagedEnvironmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerAppManagedEnvironmentResource IOperationSource<ContainerAppManagedEnvironmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerAppManagedEnvironmentData.DeserializeContainerAppManagedEnvironmentData(document.RootElement);
            return new ContainerAppManagedEnvironmentResource(_client, data);
        }

        async ValueTask<ContainerAppManagedEnvironmentResource> IOperationSource<ContainerAppManagedEnvironmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerAppManagedEnvironmentData.DeserializeContainerAppManagedEnvironmentData(document.RootElement);
            return new ContainerAppManagedEnvironmentResource(_client, data);
        }
    }
}
