// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppContainers
{
    internal class ContainerAppJobOperationSource : IOperationSource<ContainerAppJobResource>
    {
        private readonly ArmClient _client;

        internal ContainerAppJobOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerAppJobResource IOperationSource<ContainerAppJobResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerAppJobData.DeserializeContainerAppJobData(document.RootElement);
            return new ContainerAppJobResource(_client, data);
        }

        async ValueTask<ContainerAppJobResource> IOperationSource<ContainerAppJobResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerAppJobData.DeserializeContainerAppJobData(document.RootElement);
            return new ContainerAppJobResource(_client, data);
        }
    }
}
