// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppContainers
{
    internal class ContainerAppConnectedEnvironmentOperationSource : IOperationSource<ContainerAppConnectedEnvironmentResource>
    {
        private readonly ArmClient _client;

        internal ContainerAppConnectedEnvironmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerAppConnectedEnvironmentResource IOperationSource<ContainerAppConnectedEnvironmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerAppConnectedEnvironmentData.DeserializeContainerAppConnectedEnvironmentData(document.RootElement);
            return new ContainerAppConnectedEnvironmentResource(_client, data);
        }

        async ValueTask<ContainerAppConnectedEnvironmentResource> IOperationSource<ContainerAppConnectedEnvironmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerAppConnectedEnvironmentData.DeserializeContainerAppConnectedEnvironmentData(document.RootElement);
            return new ContainerAppConnectedEnvironmentResource(_client, data);
        }
    }
}
