// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.AppContainers.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AppContainers
{
    public partial class ContainerAppManagedEnvironmentData : IUtf8JsonSerializable, IJsonModel<ContainerAppManagedEnvironmentData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerAppManagedEnvironmentData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerAppManagedEnvironmentData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppManagedEnvironmentData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerAppManagedEnvironmentData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Kind))
            {
                writer.WritePropertyName("kind"u8);
                writer.WriteStringValue(Kind);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(DaprAIInstrumentationKey))
            {
                writer.WritePropertyName("daprAIInstrumentationKey"u8);
                writer.WriteStringValue(DaprAIInstrumentationKey);
            }
            if (Optional.IsDefined(DaprAIConnectionString))
            {
                writer.WritePropertyName("daprAIConnectionString"u8);
                writer.WriteStringValue(DaprAIConnectionString);
            }
            if (Optional.IsDefined(VnetConfiguration))
            {
                writer.WritePropertyName("vnetConfiguration"u8);
                writer.WriteObjectValue(VnetConfiguration, options);
            }
            if (options.Format != "W" && Optional.IsDefined(DeploymentErrors))
            {
                writer.WritePropertyName("deploymentErrors"u8);
                writer.WriteStringValue(DeploymentErrors);
            }
            if (options.Format != "W" && Optional.IsDefined(DefaultDomain))
            {
                writer.WritePropertyName("defaultDomain"u8);
                writer.WriteStringValue(DefaultDomain);
            }
            if (options.Format != "W" && Optional.IsDefined(StaticIP))
            {
                writer.WritePropertyName("staticIp"u8);
                writer.WriteStringValue(StaticIP.ToString());
            }
            if (Optional.IsDefined(AppLogsConfiguration))
            {
                writer.WritePropertyName("appLogsConfiguration"u8);
                writer.WriteObjectValue(AppLogsConfiguration, options);
            }
            if (Optional.IsDefined(IsZoneRedundant))
            {
                writer.WritePropertyName("zoneRedundant"u8);
                writer.WriteBooleanValue(IsZoneRedundant.Value);
            }
            if (Optional.IsDefined(CustomDomainConfiguration))
            {
                writer.WritePropertyName("customDomainConfiguration"u8);
                writer.WriteObjectValue(CustomDomainConfiguration, options);
            }
            if (options.Format != "W" && Optional.IsDefined(EventStreamEndpoint))
            {
                writer.WritePropertyName("eventStreamEndpoint"u8);
                writer.WriteStringValue(EventStreamEndpoint);
            }
            if (Optional.IsCollectionDefined(WorkloadProfiles))
            {
                writer.WritePropertyName("workloadProfiles"u8);
                writer.WriteStartArray();
                foreach (var item in WorkloadProfiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(KedaConfiguration))
            {
                writer.WritePropertyName("kedaConfiguration"u8);
                writer.WriteObjectValue(KedaConfiguration, options);
            }
            if (Optional.IsDefined(DaprConfiguration))
            {
                writer.WritePropertyName("daprConfiguration"u8);
                writer.WriteObjectValue(DaprConfiguration, options);
            }
            if (Optional.IsDefined(InfrastructureResourceGroup))
            {
                writer.WritePropertyName("infrastructureResourceGroup"u8);
                writer.WriteStringValue(InfrastructureResourceGroup);
            }
            if (Optional.IsDefined(PeerAuthentication))
            {
                writer.WritePropertyName("peerAuthentication"u8);
                writer.WriteObjectValue(PeerAuthentication, options);
            }
            if (Optional.IsDefined(PeerTrafficConfiguration))
            {
                writer.WritePropertyName("peerTrafficConfiguration"u8);
                writer.WriteObjectValue(PeerTrafficConfiguration, options);
            }
            writer.WriteEndObject();
        }

        ContainerAppManagedEnvironmentData IJsonModel<ContainerAppManagedEnvironmentData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppManagedEnvironmentData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerAppManagedEnvironmentData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerAppManagedEnvironmentData(document.RootElement, options);
        }

        internal static ContainerAppManagedEnvironmentData DeserializeContainerAppManagedEnvironmentData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string kind = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            ContainerAppEnvironmentProvisioningState? provisioningState = default;
            string daprAIInstrumentationKey = default;
            string daprAIConnectionString = default;
            ContainerAppVnetConfiguration vnetConfiguration = default;
            string deploymentErrors = default;
            string defaultDomain = default;
            IPAddress staticIP = default;
            ContainerAppLogsConfiguration appLogsConfiguration = default;
            bool? zoneRedundant = default;
            ContainerAppCustomDomainConfiguration customDomainConfiguration = default;
            string eventStreamEndpoint = default;
            IList<ContainerAppWorkloadProfile> workloadProfiles = default;
            KedaConfiguration kedaConfiguration = default;
            DaprConfiguration daprConfiguration = default;
            string infrastructureResourceGroup = default;
            ManagedEnvironmentPropertiesPeerAuthentication peerAuthentication = default;
            ManagedEnvironmentPropertiesPeerTrafficConfiguration peerTrafficConfiguration = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("kind"u8))
                {
                    kind = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new ContainerAppEnvironmentProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("daprAIInstrumentationKey"u8))
                        {
                            daprAIInstrumentationKey = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("daprAIConnectionString"u8))
                        {
                            daprAIConnectionString = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("vnetConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            vnetConfiguration = ContainerAppVnetConfiguration.DeserializeContainerAppVnetConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("deploymentErrors"u8))
                        {
                            deploymentErrors = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("defaultDomain"u8))
                        {
                            defaultDomain = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("staticIp"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            staticIP = IPAddress.Parse(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("appLogsConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            appLogsConfiguration = ContainerAppLogsConfiguration.DeserializeContainerAppLogsConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("zoneRedundant"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            zoneRedundant = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("customDomainConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            customDomainConfiguration = ContainerAppCustomDomainConfiguration.DeserializeContainerAppCustomDomainConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("eventStreamEndpoint"u8))
                        {
                            eventStreamEndpoint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("workloadProfiles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ContainerAppWorkloadProfile> array = new List<ContainerAppWorkloadProfile>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ContainerAppWorkloadProfile.DeserializeContainerAppWorkloadProfile(item, options));
                            }
                            workloadProfiles = array;
                            continue;
                        }
                        if (property0.NameEquals("kedaConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            kedaConfiguration = KedaConfiguration.DeserializeKedaConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("daprConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            daprConfiguration = DaprConfiguration.DeserializeDaprConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("infrastructureResourceGroup"u8))
                        {
                            infrastructureResourceGroup = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("peerAuthentication"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            peerAuthentication = ManagedEnvironmentPropertiesPeerAuthentication.DeserializeManagedEnvironmentPropertiesPeerAuthentication(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("peerTrafficConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            peerTrafficConfiguration = ManagedEnvironmentPropertiesPeerTrafficConfiguration.DeserializeManagedEnvironmentPropertiesPeerTrafficConfiguration(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerAppManagedEnvironmentData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                kind,
                provisioningState,
                daprAIInstrumentationKey,
                daprAIConnectionString,
                vnetConfiguration,
                deploymentErrors,
                defaultDomain,
                staticIP,
                appLogsConfiguration,
                zoneRedundant,
                customDomainConfiguration,
                eventStreamEndpoint,
                workloadProfiles ?? new ChangeTrackingList<ContainerAppWorkloadProfile>(),
                kedaConfiguration,
                daprConfiguration,
                infrastructureResourceGroup,
                peerAuthentication,
                peerTrafficConfiguration,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  location: ");
                builder.AppendLine($"'{Location.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Kind), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  kind: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Kind))
                {
                    builder.Append("  kind: ");
                    if (Kind.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Kind}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Kind}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DaprAIInstrumentationKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    daprAIInstrumentationKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DaprAIInstrumentationKey))
                {
                    builder.Append("    daprAIInstrumentationKey: ");
                    if (DaprAIInstrumentationKey.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DaprAIInstrumentationKey}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DaprAIInstrumentationKey}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DaprAIConnectionString), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    daprAIConnectionString: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DaprAIConnectionString))
                {
                    builder.Append("    daprAIConnectionString: ");
                    if (DaprAIConnectionString.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DaprAIConnectionString}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DaprAIConnectionString}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VnetConfiguration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    vnetConfiguration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(VnetConfiguration))
                {
                    builder.Append("    vnetConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, VnetConfiguration, options, 4, false, "    vnetConfiguration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DeploymentErrors), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    deploymentErrors: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DeploymentErrors))
                {
                    builder.Append("    deploymentErrors: ");
                    if (DeploymentErrors.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DeploymentErrors}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DeploymentErrors}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DefaultDomain), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    defaultDomain: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DefaultDomain))
                {
                    builder.Append("    defaultDomain: ");
                    if (DefaultDomain.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DefaultDomain}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DefaultDomain}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StaticIP), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    staticIp: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StaticIP))
                {
                    builder.Append("    staticIp: ");
                    builder.AppendLine($"'{StaticIP.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AppLogsConfiguration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    appLogsConfiguration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AppLogsConfiguration))
                {
                    builder.Append("    appLogsConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AppLogsConfiguration, options, 4, false, "    appLogsConfiguration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsZoneRedundant), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    zoneRedundant: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsZoneRedundant))
                {
                    builder.Append("    zoneRedundant: ");
                    var boolValue = IsZoneRedundant.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomDomainConfiguration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    customDomainConfiguration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CustomDomainConfiguration))
                {
                    builder.Append("    customDomainConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CustomDomainConfiguration, options, 4, false, "    customDomainConfiguration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EventStreamEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    eventStreamEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EventStreamEndpoint))
                {
                    builder.Append("    eventStreamEndpoint: ");
                    if (EventStreamEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{EventStreamEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{EventStreamEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WorkloadProfiles), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    workloadProfiles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(WorkloadProfiles))
                {
                    if (WorkloadProfiles.Any())
                    {
                        builder.Append("    workloadProfiles: ");
                        builder.AppendLine("[");
                        foreach (var item in WorkloadProfiles)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    workloadProfiles: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("KedaVersion", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    kedaConfiguration: ");
                builder.AppendLine("{");
                builder.AppendLine("      kedaConfiguration: {");
                builder.Append("        version: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(KedaConfiguration))
                {
                    builder.Append("    kedaConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, KedaConfiguration, options, 4, false, "    kedaConfiguration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("DaprVersion", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    daprConfiguration: ");
                builder.AppendLine("{");
                builder.AppendLine("      daprConfiguration: {");
                builder.Append("        version: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(DaprConfiguration))
                {
                    builder.Append("    daprConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, DaprConfiguration, options, 4, false, "    daprConfiguration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InfrastructureResourceGroup), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    infrastructureResourceGroup: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InfrastructureResourceGroup))
                {
                    builder.Append("    infrastructureResourceGroup: ");
                    if (InfrastructureResourceGroup.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{InfrastructureResourceGroup}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{InfrastructureResourceGroup}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IsMtlsEnabled", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    peerAuthentication: ");
                builder.AppendLine("{");
                builder.AppendLine("      peerAuthentication: {");
                builder.AppendLine("        mtls: {");
                builder.Append("          enabled: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("        }");
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(PeerAuthentication))
                {
                    builder.Append("    peerAuthentication: ");
                    BicepSerializationHelpers.AppendChildObject(builder, PeerAuthentication, options, 4, false, "    peerAuthentication: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IsEnabled", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    peerTrafficConfiguration: ");
                builder.AppendLine("{");
                builder.AppendLine("      peerTrafficConfiguration: {");
                builder.AppendLine("        encryption: {");
                builder.Append("          enabled: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("        }");
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(PeerTrafficConfiguration))
                {
                    builder.Append("    peerTrafficConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, PeerTrafficConfiguration, options, 4, false, "    peerTrafficConfiguration: ");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ContainerAppManagedEnvironmentData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppManagedEnvironmentData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ContainerAppManagedEnvironmentData)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerAppManagedEnvironmentData IPersistableModel<ContainerAppManagedEnvironmentData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerAppManagedEnvironmentData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerAppManagedEnvironmentData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerAppManagedEnvironmentData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerAppManagedEnvironmentData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
