// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.AppContainers
{
    /// <summary>
    /// A class representing a collection of <see cref="ContainerAppJobDetectorPropertyResource"/> and their operations.
    /// Each <see cref="ContainerAppJobDetectorPropertyResource"/> in the collection will belong to the same instance of <see cref="ContainerAppJobResource"/>.
    /// To get a <see cref="ContainerAppJobDetectorPropertyCollection"/> instance call the GetContainerAppJobDetectorProperties method from an instance of <see cref="ContainerAppJobResource"/>.
    /// </summary>
    public partial class ContainerAppJobDetectorPropertyCollection : ArmCollection
    {
        private readonly ClientDiagnostics _containerAppJobDetectorPropertyJobsClientDiagnostics;
        private readonly JobsRestOperations _containerAppJobDetectorPropertyJobsRestClient;

        /// <summary> Initializes a new instance of the <see cref="ContainerAppJobDetectorPropertyCollection"/> class for mocking. </summary>
        protected ContainerAppJobDetectorPropertyCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ContainerAppJobDetectorPropertyCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ContainerAppJobDetectorPropertyCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _containerAppJobDetectorPropertyJobsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.AppContainers", ContainerAppJobDetectorPropertyResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ContainerAppJobDetectorPropertyResource.ResourceType, out string containerAppJobDetectorPropertyJobsApiVersion);
            _containerAppJobDetectorPropertyJobsRestClient = new JobsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, containerAppJobDetectorPropertyJobsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ContainerAppJobResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ContainerAppJobResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get the properties of a Container App Job.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/detectorProperties/{apiName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Jobs_ProxyGet</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ContainerAppJobDetectorPropertyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="apiName"> Proxy API Name for Container App Job. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="apiName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="apiName"/> is null. </exception>
        public virtual async Task<Response<ContainerAppJobDetectorPropertyResource>> GetAsync(string apiName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(apiName, nameof(apiName));

            using var scope = _containerAppJobDetectorPropertyJobsClientDiagnostics.CreateScope("ContainerAppJobDetectorPropertyCollection.Get");
            scope.Start();
            try
            {
                var response = await _containerAppJobDetectorPropertyJobsRestClient.ProxyGetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, apiName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ContainerAppJobDetectorPropertyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the properties of a Container App Job.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/detectorProperties/{apiName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Jobs_ProxyGet</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ContainerAppJobDetectorPropertyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="apiName"> Proxy API Name for Container App Job. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="apiName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="apiName"/> is null. </exception>
        public virtual Response<ContainerAppJobDetectorPropertyResource> Get(string apiName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(apiName, nameof(apiName));

            using var scope = _containerAppJobDetectorPropertyJobsClientDiagnostics.CreateScope("ContainerAppJobDetectorPropertyCollection.Get");
            scope.Start();
            try
            {
                var response = _containerAppJobDetectorPropertyJobsRestClient.ProxyGet(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, apiName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ContainerAppJobDetectorPropertyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/detectorProperties/{apiName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Jobs_ProxyGet</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ContainerAppJobDetectorPropertyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="apiName"> Proxy API Name for Container App Job. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="apiName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="apiName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string apiName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(apiName, nameof(apiName));

            using var scope = _containerAppJobDetectorPropertyJobsClientDiagnostics.CreateScope("ContainerAppJobDetectorPropertyCollection.Exists");
            scope.Start();
            try
            {
                var response = await _containerAppJobDetectorPropertyJobsRestClient.ProxyGetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, apiName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/detectorProperties/{apiName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Jobs_ProxyGet</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ContainerAppJobDetectorPropertyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="apiName"> Proxy API Name for Container App Job. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="apiName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="apiName"/> is null. </exception>
        public virtual Response<bool> Exists(string apiName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(apiName, nameof(apiName));

            using var scope = _containerAppJobDetectorPropertyJobsClientDiagnostics.CreateScope("ContainerAppJobDetectorPropertyCollection.Exists");
            scope.Start();
            try
            {
                var response = _containerAppJobDetectorPropertyJobsRestClient.ProxyGet(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, apiName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/detectorProperties/{apiName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Jobs_ProxyGet</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ContainerAppJobDetectorPropertyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="apiName"> Proxy API Name for Container App Job. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="apiName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="apiName"/> is null. </exception>
        public virtual async Task<NullableResponse<ContainerAppJobDetectorPropertyResource>> GetIfExistsAsync(string apiName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(apiName, nameof(apiName));

            using var scope = _containerAppJobDetectorPropertyJobsClientDiagnostics.CreateScope("ContainerAppJobDetectorPropertyCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _containerAppJobDetectorPropertyJobsRestClient.ProxyGetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, apiName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ContainerAppJobDetectorPropertyResource>(response.GetRawResponse());
                return Response.FromValue(new ContainerAppJobDetectorPropertyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/detectorProperties/{apiName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Jobs_ProxyGet</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ContainerAppJobDetectorPropertyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="apiName"> Proxy API Name for Container App Job. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="apiName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="apiName"/> is null. </exception>
        public virtual NullableResponse<ContainerAppJobDetectorPropertyResource> GetIfExists(string apiName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(apiName, nameof(apiName));

            using var scope = _containerAppJobDetectorPropertyJobsClientDiagnostics.CreateScope("ContainerAppJobDetectorPropertyCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _containerAppJobDetectorPropertyJobsRestClient.ProxyGet(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, apiName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ContainerAppJobDetectorPropertyResource>(response.GetRawResponse());
                return Response.FromValue(new ContainerAppJobDetectorPropertyResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
