// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.AppContainers.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AppContainers
{
    /// <summary>
    /// A class representing the ContainerAppJob data model.
    /// Container App Job
    /// </summary>
    public partial class ContainerAppJobData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppJobData"/>. </summary>
        /// <param name="location"> The location. </param>
        public ContainerAppJobData(AzureLocation location) : base(location)
        {
            OutboundIPAddresses = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials in code. </param>
        /// <param name="provisioningState"> Provisioning state of the Container Apps Job. </param>
        /// <param name="environmentId"> Resource ID of environment. </param>
        /// <param name="workloadProfileName"> Workload profile name to pin for container apps job execution. </param>
        /// <param name="configuration"> Container Apps Job configuration properties. </param>
        /// <param name="template"> Container Apps job definition. </param>
        /// <param name="outboundIPAddresses"> Outbound IP Addresses of a container apps job. </param>
        /// <param name="eventStreamEndpoint"> The endpoint of the eventstream of the container apps job. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppJobData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, ContainerAppJobProvisioningState? provisioningState, string environmentId, string workloadProfileName, ContainerAppJobConfiguration configuration, ContainerAppJobTemplate template, IReadOnlyList<string> outboundIPAddresses, string eventStreamEndpoint, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            ProvisioningState = provisioningState;
            EnvironmentId = environmentId;
            WorkloadProfileName = workloadProfileName;
            Configuration = configuration;
            Template = template;
            OutboundIPAddresses = outboundIPAddresses;
            EventStreamEndpoint = eventStreamEndpoint;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppJobData"/> for deserialization. </summary>
        internal ContainerAppJobData()
        {
        }

        /// <summary> Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials in code. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> Provisioning state of the Container Apps Job. </summary>
        [WirePath("properties.provisioningState")]
        public ContainerAppJobProvisioningState? ProvisioningState { get; }
        /// <summary> Resource ID of environment. </summary>
        [WirePath("properties.environmentId")]
        public string EnvironmentId { get; set; }
        /// <summary> Workload profile name to pin for container apps job execution. </summary>
        [WirePath("properties.workloadProfileName")]
        public string WorkloadProfileName { get; set; }
        /// <summary> Container Apps Job configuration properties. </summary>
        [WirePath("properties.configuration")]
        public ContainerAppJobConfiguration Configuration { get; set; }
        /// <summary> Container Apps job definition. </summary>
        [WirePath("properties.template")]
        public ContainerAppJobTemplate Template { get; set; }
        /// <summary> Outbound IP Addresses of a container apps job. </summary>
        [WirePath("properties.outboundIpAddresses")]
        public IReadOnlyList<string> OutboundIPAddresses { get; }
        /// <summary> The endpoint of the eventstream of the container apps job. </summary>
        [WirePath("properties.eventStreamEndpoint")]
        public string EventStreamEndpoint { get; }
    }
}
