// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.AppContainers.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AppContainers
{
    /// <summary>
    /// A class representing the ContainerApp data model.
    /// Container App.
    /// </summary>
    public partial class ContainerAppData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppData"/>. </summary>
        /// <param name="location"> The location. </param>
        public ContainerAppData(AzureLocation location) : base(location)
        {
            OutboundIPAddressList = new ChangeTrackingList<IPAddress>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The complex type of the extended location. </param>
        /// <param name="identity"> managed identities for the Container App to interact with other Azure services without maintaining any secrets or credentials in code. </param>
        /// <param name="managedBy"> The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource. </param>
        /// <param name="provisioningState"> Provisioning state of the Container App. </param>
        /// <param name="managedEnvironmentId"> Deprecated. Resource ID of the Container App's environment. </param>
        /// <param name="environmentId"> Resource ID of environment. </param>
        /// <param name="workloadProfileName"> Workload profile name to pin for container app execution. </param>
        /// <param name="latestRevisionName"> Name of the latest revision of the Container App. </param>
        /// <param name="latestReadyRevisionName"> Name of the latest ready revision of the Container App. </param>
        /// <param name="latestRevisionFqdn"> Fully Qualified Domain Name of the latest revision of the Container App. </param>
        /// <param name="customDomainVerificationId"> Id used to verify domain name ownership. </param>
        /// <param name="configuration"> Non versioned Container App configuration properties. </param>
        /// <param name="template"> Container App versioned application definition. </param>
        /// <param name="outboundIPAddressList"> Outbound IP Addresses for container app. </param>
        /// <param name="eventStreamEndpoint"> The endpoint of the eventstream of the container app. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ContainerAppExtendedLocation extendedLocation, ManagedServiceIdentity identity, string managedBy, ContainerAppProvisioningState? provisioningState, ResourceIdentifier managedEnvironmentId, ResourceIdentifier environmentId, string workloadProfileName, string latestRevisionName, string latestReadyRevisionName, string latestRevisionFqdn, string customDomainVerificationId, ContainerAppConfiguration configuration, ContainerAppTemplate template, IReadOnlyList<IPAddress> outboundIPAddressList, Uri eventStreamEndpoint, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ExtendedLocation = extendedLocation;
            Identity = identity;
            ManagedBy = managedBy;
            ProvisioningState = provisioningState;
            ManagedEnvironmentId = managedEnvironmentId;
            EnvironmentId = environmentId;
            WorkloadProfileName = workloadProfileName;
            LatestRevisionName = latestRevisionName;
            LatestReadyRevisionName = latestReadyRevisionName;
            LatestRevisionFqdn = latestRevisionFqdn;
            CustomDomainVerificationId = customDomainVerificationId;
            Configuration = configuration;
            Template = template;
            OutboundIPAddressList = outboundIPAddressList;
            EventStreamEndpoint = eventStreamEndpoint;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppData"/> for deserialization. </summary>
        internal ContainerAppData()
        {
        }

        /// <summary> The complex type of the extended location. </summary>
        [WirePath("extendedLocation")]
        public ContainerAppExtendedLocation ExtendedLocation { get; set; }
        /// <summary> managed identities for the Container App to interact with other Azure services without maintaining any secrets or credentials in code. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource. </summary>
        [WirePath("managedBy")]
        public string ManagedBy { get; set; }
        /// <summary> Provisioning state of the Container App. </summary>
        [WirePath("properties.provisioningState")]
        public ContainerAppProvisioningState? ProvisioningState { get; }
        /// <summary> Deprecated. Resource ID of the Container App's environment. </summary>
        [WirePath("properties.managedEnvironmentId")]
        public ResourceIdentifier ManagedEnvironmentId { get; set; }
        /// <summary> Resource ID of environment. </summary>
        [WirePath("properties.environmentId")]
        public ResourceIdentifier EnvironmentId { get; set; }
        /// <summary> Workload profile name to pin for container app execution. </summary>
        [WirePath("properties.workloadProfileName")]
        public string WorkloadProfileName { get; set; }
        /// <summary> Name of the latest revision of the Container App. </summary>
        [WirePath("properties.latestRevisionName")]
        public string LatestRevisionName { get; }
        /// <summary> Name of the latest ready revision of the Container App. </summary>
        [WirePath("properties.latestReadyRevisionName")]
        public string LatestReadyRevisionName { get; }
        /// <summary> Fully Qualified Domain Name of the latest revision of the Container App. </summary>
        [WirePath("properties.latestRevisionFqdn")]
        public string LatestRevisionFqdn { get; }
        /// <summary> Id used to verify domain name ownership. </summary>
        [WirePath("properties.customDomainVerificationId")]
        public string CustomDomainVerificationId { get; }
        /// <summary> Non versioned Container App configuration properties. </summary>
        [WirePath("properties.configuration")]
        public ContainerAppConfiguration Configuration { get; set; }
        /// <summary> Container App versioned application definition. </summary>
        [WirePath("properties.template")]
        public ContainerAppTemplate Template { get; set; }
        /// <summary> Outbound IP Addresses for container app. </summary>
        [WirePath("properties.outboundIpAddresses")]
        public IReadOnlyList<IPAddress> OutboundIPAddressList { get; }
        /// <summary> The endpoint of the eventstream of the container app. </summary>
        [WirePath("properties.eventStreamEndpoint")]
        public Uri EventStreamEndpoint { get; }
    }
}
