// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.AppContainers.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AppContainers
{
    /// <summary>
    /// A class representing the ContainerAppAuthConfig data model.
    /// Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
    /// </summary>
    public partial class ContainerAppAuthConfigData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerAppAuthConfigData"/>. </summary>
        public ContainerAppAuthConfigData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerAppAuthConfigData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="platform"> The configuration settings of the platform of ContainerApp Service Authentication/Authorization. </param>
        /// <param name="globalValidation"> The configuration settings that determines the validation flow of users using  Service Authentication/Authorization. </param>
        /// <param name="identityProviders"> The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization. </param>
        /// <param name="login"> The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization. </param>
        /// <param name="httpSettings"> The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization. </param>
        /// <param name="encryptionSettings"> The configuration settings of the secrets references of encryption key and signing key for ContainerApp Service Authentication/Authorization. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerAppAuthConfigData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ContainerAppAuthPlatform platform, ContainerAppGlobalValidation globalValidation, ContainerAppIdentityProvidersConfiguration identityProviders, ContainerAppLogin login, ContainerAppHttpSettings httpSettings, EncryptionSettings encryptionSettings, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Platform = platform;
            GlobalValidation = globalValidation;
            IdentityProviders = identityProviders;
            Login = login;
            HttpSettings = httpSettings;
            EncryptionSettings = encryptionSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The configuration settings of the platform of ContainerApp Service Authentication/Authorization. </summary>
        [WirePath("properties.platform")]
        public ContainerAppAuthPlatform Platform { get; set; }
        /// <summary> The configuration settings that determines the validation flow of users using  Service Authentication/Authorization. </summary>
        [WirePath("properties.globalValidation")]
        public ContainerAppGlobalValidation GlobalValidation { get; set; }
        /// <summary> The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization. </summary>
        [WirePath("properties.identityProviders")]
        public ContainerAppIdentityProvidersConfiguration IdentityProviders { get; set; }
        /// <summary> The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization. </summary>
        [WirePath("properties.login")]
        public ContainerAppLogin Login { get; set; }
        /// <summary> The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization. </summary>
        [WirePath("properties.httpSettings")]
        public ContainerAppHttpSettings HttpSettings { get; set; }
        /// <summary> The configuration settings of the secrets references of encryption key and signing key for ContainerApp Service Authentication/Authorization. </summary>
        [WirePath("properties.encryptionSettings")]
        public EncryptionSettings EncryptionSettings { get; set; }
    }
}
