// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmAppContainersModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppAuthConfigData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="platform"> The configuration settings of the platform of ContainerApp Service Authentication/Authorization. </param>
        /// <param name="globalValidation"> The configuration settings that determines the validation flow of users using  Service Authentication/Authorization. </param>
        /// <param name="identityProviders"> The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization. </param>
        /// <param name="login"> The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization. </param>
        /// <param name="httpSettings"> The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization. </param>
        /// <param name="encryptionSettings"> The configuration settings of the secrets references of encryption key and signing key for ContainerApp Service Authentication/Authorization. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppAuthConfigData"/> instance for mocking. </returns>
        public static ContainerAppAuthConfigData ContainerAppAuthConfigData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ContainerAppAuthPlatform platform = null, ContainerAppGlobalValidation globalValidation = null, ContainerAppIdentityProvidersConfiguration identityProviders = null, ContainerAppLogin login = null, ContainerAppHttpSettings httpSettings = null, EncryptionSettings encryptionSettings = null)
        {
            return new ContainerAppAuthConfigData(
                id,
                name,
                resourceType,
                systemData,
                platform,
                globalValidation,
                identityProviders,
                login,
                httpSettings,
                encryptionSettings,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppAvailableWorkloadProfile"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Region of the workload profile. </param>
        /// <param name="properties"> Revision resource specific properties. </param>
        /// <returns> A new <see cref="Models.ContainerAppAvailableWorkloadProfile"/> instance for mocking. </returns>
        public static ContainerAppAvailableWorkloadProfile ContainerAppAvailableWorkloadProfile(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ContainerAppAvailableWorkloadProfileProperties properties = null)
        {
            return new ContainerAppAvailableWorkloadProfile(
                id,
                name,
                resourceType,
                systemData,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppBillingMeter"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Region for the billing meter. </param>
        /// <param name="properties"> Revision resource specific properties. </param>
        /// <returns> A new <see cref="Models.ContainerAppBillingMeter"/> instance for mocking. </returns>
        public static ContainerAppBillingMeter ContainerAppBillingMeter(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ContainerAppBillingMeterProperties properties = null)
        {
            return new ContainerAppBillingMeter(
                id,
                name,
                resourceType,
                systemData,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppConnectedEnvironmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The complex type of the extended location. </param>
        /// <param name="provisioningState"> Provisioning state of the Kubernetes Environment. </param>
        /// <param name="deploymentErrors"> Any errors that occurred during deployment or deployment validation. </param>
        /// <param name="defaultDomain"> Default Domain Name for the cluster. </param>
        /// <param name="staticIP"> Static IP of the connectedEnvironment. </param>
        /// <param name="daprAIConnectionString"> Application Insights connection string used by Dapr to export Service to Service communication telemetry. </param>
        /// <param name="customDomainConfiguration"> Custom domain configuration for the environment. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppConnectedEnvironmentData"/> instance for mocking. </returns>
        public static ContainerAppConnectedEnvironmentData ContainerAppConnectedEnvironmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ContainerAppExtendedLocation extendedLocation = null, ContainerAppConnectedEnvironmentProvisioningState? provisioningState = null, string deploymentErrors = null, string defaultDomain = null, IPAddress staticIP = null, string daprAIConnectionString = null, ContainerAppCustomDomainConfiguration customDomainConfiguration = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ContainerAppConnectedEnvironmentData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                extendedLocation,
                provisioningState,
                deploymentErrors,
                defaultDomain,
                staticIP,
                daprAIConnectionString,
                customDomainConfiguration,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppCustomDomainConfiguration"/>. </summary>
        /// <param name="customDomainVerificationId"> Id used to verify domain name ownership. </param>
        /// <param name="dnsSuffix"> Dns suffix for the environment domain. </param>
        /// <param name="certificateValue"> PFX or PEM blob. </param>
        /// <param name="certificatePassword"> Certificate password. </param>
        /// <param name="expireOn"> Certificate expiration date. </param>
        /// <param name="thumbprint"> Certificate thumbprint. </param>
        /// <param name="subjectName"> Subject name of the certificate. </param>
        /// <returns> A new <see cref="Models.ContainerAppCustomDomainConfiguration"/> instance for mocking. </returns>
        public static ContainerAppCustomDomainConfiguration ContainerAppCustomDomainConfiguration(string customDomainVerificationId = null, string dnsSuffix = null, byte[] certificateValue = null, string certificatePassword = null, DateTimeOffset? expireOn = null, string thumbprint = null, string subjectName = null)
        {
            return new ContainerAppCustomDomainConfiguration(
                customDomainVerificationId,
                dnsSuffix,
                certificateValue,
                certificatePassword,
                expireOn,
                thumbprint,
                subjectName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Indicates if the resource name is available. </param>
        /// <param name="reason"> The reason why the given name is not available. </param>
        /// <param name="message"> Detailed reason why the given name is available. </param>
        /// <returns> A new <see cref="Models.ContainerAppNameAvailabilityResult"/> instance for mocking. </returns>
        public static ContainerAppNameAvailabilityResult ContainerAppNameAvailabilityResult(bool? isNameAvailable = null, ContainerAppNameUnavailableReason? reason = null, string message = null)
        {
            return new ContainerAppNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppCertificateData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Certificate resource specific properties. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppCertificateData"/> instance for mocking. </returns>
        public static ContainerAppCertificateData ContainerAppCertificateData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ContainerAppCertificateProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ContainerAppCertificateData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppCertificateProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the certificate. </param>
        /// <param name="password"> Certificate password. </param>
        /// <param name="subjectName"> Subject name of the certificate. </param>
        /// <param name="subjectAlternativeNames"> Subject alternative names the certificate applies to. </param>
        /// <param name="value"> PFX or PEM blob. </param>
        /// <param name="issuer"> Certificate issuer. </param>
        /// <param name="issueOn"> Certificate issue Date. </param>
        /// <param name="expireOn"> Certificate expiration date. </param>
        /// <param name="thumbprint"> Certificate thumbprint. </param>
        /// <param name="isValid"> Is the certificate valid?. </param>
        /// <param name="publicKeyHash"> Public key hash. </param>
        /// <returns> A new <see cref="Models.ContainerAppCertificateProperties"/> instance for mocking. </returns>
        public static ContainerAppCertificateProperties ContainerAppCertificateProperties(ContainerAppCertificateProvisioningState? provisioningState = null, string password = null, string subjectName = null, IEnumerable<string> subjectAlternativeNames = null, byte[] value = null, string issuer = null, DateTimeOffset? issueOn = null, DateTimeOffset? expireOn = null, string thumbprint = null, bool? isValid = null, string publicKeyHash = null)
        {
            subjectAlternativeNames ??= new List<string>();

            return new ContainerAppCertificateProperties(
                provisioningState,
                password,
                subjectName,
                subjectAlternativeNames?.ToList(),
                value,
                issuer,
                issueOn,
                expireOn,
                thumbprint,
                isValid,
                publicKeyHash,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppDaprComponentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="componentType"> Component type. </param>
        /// <param name="version"> Component version. </param>
        /// <param name="ignoreErrors"> Boolean describing if the component errors are ignores. </param>
        /// <param name="initTimeout"> Initialization timeout. </param>
        /// <param name="secrets"> Collection of secrets used by a Dapr component. </param>
        /// <param name="secretStoreComponent"> Name of a Dapr component to retrieve component secrets from. </param>
        /// <param name="metadata"> Component metadata. </param>
        /// <param name="scopes"> Names of container apps that can use this Dapr component. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppDaprComponentData"/> instance for mocking. </returns>
        public static ContainerAppDaprComponentData ContainerAppDaprComponentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string componentType = null, string version = null, bool? ignoreErrors = null, string initTimeout = null, IEnumerable<ContainerAppWritableSecret> secrets = null, string secretStoreComponent = null, IEnumerable<ContainerAppDaprMetadata> metadata = null, IEnumerable<string> scopes = null)
        {
            secrets ??= new List<ContainerAppWritableSecret>();
            metadata ??= new List<ContainerAppDaprMetadata>();
            scopes ??= new List<string>();

            return new ContainerAppDaprComponentData(
                id,
                name,
                resourceType,
                systemData,
                componentType,
                version,
                ignoreErrors,
                initTimeout,
                secrets?.ToList(),
                secretStoreComponent,
                metadata?.ToList(),
                scopes?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppDaprSecret"/>. </summary>
        /// <param name="name"> Secret Name. </param>
        /// <param name="value"> Secret Value. </param>
        /// <returns> A new <see cref="Models.ContainerAppDaprSecret"/> instance for mocking. </returns>
        public static ContainerAppDaprSecret ContainerAppDaprSecret(string name = null, string value = null)
        {
            return new ContainerAppDaprSecret(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppConnectedEnvironmentStorageData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="connectedEnvironmentStorageAzureFile"> Storage properties. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppConnectedEnvironmentStorageData"/> instance for mocking. </returns>
        public static ContainerAppConnectedEnvironmentStorageData ContainerAppConnectedEnvironmentStorageData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ContainerAppAzureFileProperties connectedEnvironmentStorageAzureFile = null)
        {
            return new ContainerAppConnectedEnvironmentStorageData(
                id,
                name,
                resourceType,
                systemData,
                connectedEnvironmentStorageAzureFile != null ? new ConnectedEnvironmentStorageProperties(connectedEnvironmentStorageAzureFile, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The complex type of the extended location. </param>
        /// <param name="identity"> managed identities for the Container App to interact with other Azure services without maintaining any secrets or credentials in code. </param>
        /// <param name="managedBy"> The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource. </param>
        /// <param name="provisioningState"> Provisioning state of the Container App. </param>
        /// <param name="managedEnvironmentId"> Deprecated. Resource ID of the Container App's environment. </param>
        /// <param name="environmentId"> Resource ID of environment. </param>
        /// <param name="workloadProfileName"> Workload profile name to pin for container app execution. </param>
        /// <param name="latestRevisionName"> Name of the latest revision of the Container App. </param>
        /// <param name="latestReadyRevisionName"> Name of the latest ready revision of the Container App. </param>
        /// <param name="latestRevisionFqdn"> Fully Qualified Domain Name of the latest revision of the Container App. </param>
        /// <param name="customDomainVerificationId"> Id used to verify domain name ownership. </param>
        /// <param name="configuration"> Non versioned Container App configuration properties. </param>
        /// <param name="template"> Container App versioned application definition. </param>
        /// <param name="outboundIPAddressList"> Outbound IP Addresses for container app. </param>
        /// <param name="eventStreamEndpoint"> The endpoint of the eventstream of the container app. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppData"/> instance for mocking. </returns>
        public static ContainerAppData ContainerAppData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ContainerAppExtendedLocation extendedLocation = null, ManagedServiceIdentity identity = null, string managedBy = null, ContainerAppProvisioningState? provisioningState = null, ResourceIdentifier managedEnvironmentId = null, ResourceIdentifier environmentId = null, string workloadProfileName = null, string latestRevisionName = null, string latestReadyRevisionName = null, string latestRevisionFqdn = null, string customDomainVerificationId = null, ContainerAppConfiguration configuration = null, ContainerAppTemplate template = null, IEnumerable<IPAddress> outboundIPAddressList = null, Uri eventStreamEndpoint = null)
        {
            tags ??= new Dictionary<string, string>();
            outboundIPAddressList ??= new List<IPAddress>();

            return new ContainerAppData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                extendedLocation,
                identity,
                managedBy,
                provisioningState,
                managedEnvironmentId,
                environmentId,
                workloadProfileName,
                latestRevisionName,
                latestReadyRevisionName,
                latestRevisionFqdn,
                customDomainVerificationId,
                configuration,
                template,
                outboundIPAddressList?.ToList(),
                eventStreamEndpoint,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppIngressConfiguration"/>. </summary>
        /// <param name="fqdn"> Hostname. </param>
        /// <param name="external"> Bool indicating if app exposes an external http endpoint. </param>
        /// <param name="targetPort"> Target Port in containers for traffic from ingress. </param>
        /// <param name="exposedPort"> Exposed Port in containers for TCP traffic from ingress. </param>
        /// <param name="transport"> Ingress transport protocol. </param>
        /// <param name="traffic"> Traffic weights for app's revisions. </param>
        /// <param name="customDomains"> custom domain bindings for Container Apps' hostnames. </param>
        /// <param name="allowInsecure"> Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections. </param>
        /// <param name="ipSecurityRestrictions"> Rules to restrict incoming IP address. </param>
        /// <param name="stickySessionsAffinity"> Sticky Sessions for Single Revision Mode. </param>
        /// <param name="clientCertificateMode"> Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate. </param>
        /// <param name="corsPolicy"> CORS policy for container app. </param>
        /// <param name="additionalPortMappings"> Settings to expose additional ports on container app. </param>
        /// <returns> A new <see cref="Models.ContainerAppIngressConfiguration"/> instance for mocking. </returns>
        public static ContainerAppIngressConfiguration ContainerAppIngressConfiguration(string fqdn = null, bool? external = null, int? targetPort = null, int? exposedPort = null, ContainerAppIngressTransportMethod? transport = null, IEnumerable<ContainerAppRevisionTrafficWeight> traffic = null, IEnumerable<ContainerAppCustomDomain> customDomains = null, bool? allowInsecure = null, IEnumerable<ContainerAppIPSecurityRestrictionRule> ipSecurityRestrictions = null, Affinity? stickySessionsAffinity = null, ContainerAppIngressClientCertificateMode? clientCertificateMode = null, ContainerAppCorsPolicy corsPolicy = null, IEnumerable<IngressPortMapping> additionalPortMappings = null)
        {
            traffic ??= new List<ContainerAppRevisionTrafficWeight>();
            customDomains ??= new List<ContainerAppCustomDomain>();
            ipSecurityRestrictions ??= new List<ContainerAppIPSecurityRestrictionRule>();
            additionalPortMappings ??= new List<IngressPortMapping>();

            return new ContainerAppIngressConfiguration(
                fqdn,
                external,
                targetPort,
                exposedPort,
                transport,
                traffic?.ToList(),
                customDomains?.ToList(),
                allowInsecure,
                ipSecurityRestrictions?.ToList(),
                stickySessionsAffinity != null ? new IngressStickySessions(stickySessionsAffinity, serializedAdditionalRawData: null) : null,
                clientCertificateMode,
                corsPolicy,
                additionalPortMappings?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppContainerResources"/>. </summary>
        /// <param name="cpu"> Required CPU in cores, e.g. 0.5. </param>
        /// <param name="memory"> Required memory, e.g. "250Mb". </param>
        /// <param name="ephemeralStorage"> Ephemeral Storage, e.g. "1Gi". </param>
        /// <returns> A new <see cref="Models.AppContainerResources"/> instance for mocking. </returns>
        public static AppContainerResources AppContainerResources(double? cpu = null, string memory = null, string ephemeralStorage = null)
        {
            return new AppContainerResources(cpu, memory, ephemeralStorage, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppCustomHostnameAnalysisResult"/>. </summary>
        /// <param name="hostName"> Host name that was analyzed. </param>
        /// <param name="isHostnameAlreadyVerified"> &lt;code&gt;true&lt;/code&gt; if hostname is already verified; otherwise, &lt;code&gt;false&lt;/code&gt;. </param>
        /// <param name="customDomainVerificationTest"> DNS verification test result. </param>
        /// <param name="customDomainVerificationFailureInfo"> Raw failure information if DNS verification fails. </param>
        /// <param name="hasConflictOnManagedEnvironment"> &lt;code&gt;true&lt;/code&gt; if there is a conflict on the Container App's managed environment; otherwise, &lt;code&gt;false&lt;/code&gt;. </param>
        /// <param name="conflictWithEnvironmentCustomDomain"> &lt;code&gt;true&lt;/code&gt; if there is a conflict on the Container App's managed environment level custom domain; otherwise, &lt;code&gt;false&lt;/code&gt;. </param>
        /// <param name="conflictingContainerAppResourceId"> Name of the conflicting Container App on the Managed Environment if it's within the same subscription. </param>
        /// <param name="cNameRecords"> CName records visible for this hostname. </param>
        /// <param name="txtRecords"> TXT records visible for this hostname. </param>
        /// <param name="aRecords"> A records visible for this hostname. </param>
        /// <param name="alternateCNameRecords"> Alternate CName records visible for this hostname. </param>
        /// <param name="alternateTxtRecords"> Alternate TXT records visible for this hostname. </param>
        /// <returns> A new <see cref="Models.ContainerAppCustomHostnameAnalysisResult"/> instance for mocking. </returns>
        public static ContainerAppCustomHostnameAnalysisResult ContainerAppCustomHostnameAnalysisResult(string hostName = null, bool? isHostnameAlreadyVerified = null, ContainerAppDnsVerificationTestResult? customDomainVerificationTest = null, ContainerAppCustomDomainVerificationFailureInfo customDomainVerificationFailureInfo = null, bool? hasConflictOnManagedEnvironment = null, bool? conflictWithEnvironmentCustomDomain = null, string conflictingContainerAppResourceId = null, IEnumerable<string> cNameRecords = null, IEnumerable<string> txtRecords = null, IEnumerable<string> aRecords = null, IEnumerable<string> alternateCNameRecords = null, IEnumerable<string> alternateTxtRecords = null)
        {
            cNameRecords ??= new List<string>();
            txtRecords ??= new List<string>();
            aRecords ??= new List<string>();
            alternateCNameRecords ??= new List<string>();
            alternateTxtRecords ??= new List<string>();

            return new ContainerAppCustomHostnameAnalysisResult(
                hostName,
                isHostnameAlreadyVerified,
                customDomainVerificationTest,
                customDomainVerificationFailureInfo,
                hasConflictOnManagedEnvironment,
                conflictWithEnvironmentCustomDomain,
                conflictingContainerAppResourceId,
                cNameRecords?.ToList(),
                txtRecords?.ToList(),
                aRecords?.ToList(),
                alternateCNameRecords?.ToList(),
                alternateTxtRecords?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppCustomDomainVerificationFailureInfo"/>. </summary>
        /// <param name="code"> Standardized string to programmatically identify the error. </param>
        /// <param name="message"> Detailed error description and debugging information. </param>
        /// <param name="target"> Detailed error description and debugging information. </param>
        /// <param name="details"> Details or the error. </param>
        /// <returns> A new <see cref="Models.ContainerAppCustomDomainVerificationFailureInfo"/> instance for mocking. </returns>
        public static ContainerAppCustomDomainVerificationFailureInfo ContainerAppCustomDomainVerificationFailureInfo(string code = null, string message = null, string target = null, IEnumerable<ContainerAppCustomDomainVerificationFailureInfoDetailsItem> details = null)
        {
            details ??= new List<ContainerAppCustomDomainVerificationFailureInfoDetailsItem>();

            return new ContainerAppCustomDomainVerificationFailureInfo(code, message, target, details?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppCustomDomainVerificationFailureInfoDetailsItem"/>. </summary>
        /// <param name="code"> Standardized string to programmatically identify the error. </param>
        /// <param name="message"> Detailed error description and debugging information. </param>
        /// <param name="target"> Detailed error description and debugging information. </param>
        /// <returns> A new <see cref="Models.ContainerAppCustomDomainVerificationFailureInfoDetailsItem"/> instance for mocking. </returns>
        public static ContainerAppCustomDomainVerificationFailureInfoDetailsItem ContainerAppCustomDomainVerificationFailureInfoDetailsItem(string code = null, string message = null, string target = null)
        {
            return new ContainerAppCustomDomainVerificationFailureInfoDetailsItem(code, message, target, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppSecret"/>. </summary>
        /// <param name="name"> Secret Name. </param>
        /// <param name="value"> Secret Value. </param>
        /// <param name="identity"> Resource ID of a managed identity to authenticate with Azure Key Vault, or System to use a system-assigned identity. </param>
        /// <param name="keyVaultUri"> Azure Key Vault URL pointing to the secret referenced by the container app. </param>
        /// <returns> A new <see cref="Models.ContainerAppSecret"/> instance for mocking. </returns>
        public static ContainerAppSecret ContainerAppSecret(string name = null, string value = null, string identity = null, Uri keyVaultUri = null)
        {
            return new ContainerAppSecret(name, value, identity, keyVaultUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppAuthToken"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="token"> Auth token value. </param>
        /// <param name="expireOn"> Token expiration date. </param>
        /// <returns> A new <see cref="Models.ContainerAppAuthToken"/> instance for mocking. </returns>
        public static ContainerAppAuthToken ContainerAppAuthToken(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string token = null, DateTimeOffset? expireOn = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ContainerAppAuthToken(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                token,
                expireOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppRevisionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn">
        /// Timestamp describing when the revision was created
        /// by controller
        /// </param>
        /// <param name="lastActiveOn"> Timestamp describing when the revision was last active. Only meaningful when revision is inactive. </param>
        /// <param name="fqdn"> Fully qualified domain name of the revision. </param>
        /// <param name="template">
        /// Container App Revision Template with all possible settings and the
        /// defaults if user did not provide them. The defaults are populated
        /// as they were at the creation time
        /// </param>
        /// <param name="isActive"> Boolean describing if the Revision is Active. </param>
        /// <param name="replicas"> Number of pods currently running for this revision. </param>
        /// <param name="trafficWeight"> Traffic weight assigned to this revision. </param>
        /// <param name="provisioningError"> Optional Field - Platform Error Message. </param>
        /// <param name="healthState"> Current health State of the revision. </param>
        /// <param name="provisioningState"> Current provisioning State of the revision. </param>
        /// <param name="runningState"> Current running state of the revision. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppRevisionData"/> instance for mocking. </returns>
        public static ContainerAppRevisionData ContainerAppRevisionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastActiveOn = null, string fqdn = null, ContainerAppTemplate template = null, bool? isActive = null, int? replicas = null, int? trafficWeight = null, string provisioningError = null, ContainerAppRevisionHealthState? healthState = null, ContainerAppRevisionProvisioningState? provisioningState = null, RevisionRunningState? runningState = null)
        {
            return new ContainerAppRevisionData(
                id,
                name,
                resourceType,
                systemData,
                createdOn,
                lastActiveOn,
                fqdn,
                template,
                isActive,
                replicas,
                trafficWeight,
                provisioningError,
                healthState,
                provisioningState,
                runningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppReplicaData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> Timestamp describing when the pod was created by controller. </param>
        /// <param name="runningState"> Current running state of the replica. </param>
        /// <param name="runningStateDetails"> The details of replica current running state. </param>
        /// <param name="containers"> The containers collection under a replica. </param>
        /// <param name="initContainers"> The init containers collection under a replica. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppReplicaData"/> instance for mocking. </returns>
        public static ContainerAppReplicaData ContainerAppReplicaData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? createdOn = null, ContainerAppReplicaRunningState? runningState = null, string runningStateDetails = null, IEnumerable<ContainerAppReplicaContainer> containers = null, IEnumerable<ContainerAppReplicaContainer> initContainers = null)
        {
            containers ??= new List<ContainerAppReplicaContainer>();
            initContainers ??= new List<ContainerAppReplicaContainer>();

            return new ContainerAppReplicaData(
                id,
                name,
                resourceType,
                systemData,
                createdOn,
                runningState,
                runningStateDetails,
                containers?.ToList(),
                initContainers?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppReplicaContainer"/>. </summary>
        /// <param name="name"> The Name of the Container. </param>
        /// <param name="containerId"> The Id of the Container. </param>
        /// <param name="isReady"> The container ready status. </param>
        /// <param name="isStarted"> The container start status. </param>
        /// <param name="restartCount"> The container restart count. </param>
        /// <param name="runningState"> Current running state of the container. </param>
        /// <param name="runningStateDetails"> The details of container current running state. </param>
        /// <param name="logStreamEndpoint"> Log Stream endpoint. </param>
        /// <param name="execEndpoint"> Container exec endpoint. </param>
        /// <returns> A new <see cref="Models.ContainerAppReplicaContainer"/> instance for mocking. </returns>
        public static ContainerAppReplicaContainer ContainerAppReplicaContainer(string name = null, string containerId = null, bool? isReady = null, bool? isStarted = null, int? restartCount = null, ContainerAppContainerRunningState? runningState = null, string runningStateDetails = null, string logStreamEndpoint = null, string execEndpoint = null)
        {
            return new ContainerAppReplicaContainer(
                name,
                containerId,
                isReady,
                isStarted,
                restartCount,
                runningState,
                runningStateDetails,
                logStreamEndpoint,
                execEndpoint,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppDiagnosticData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Diagnostics resource specific properties. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppDiagnosticData"/> instance for mocking. </returns>
        public static ContainerAppDiagnosticData ContainerAppDiagnosticData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ContainerAppDiagnosticsProperties properties = null)
        {
            return new ContainerAppDiagnosticData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppDiagnosticsMetadata"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Details of the diagnostics info. </param>
        /// <param name="author"> Authors' names of the detector. </param>
        /// <param name="category"> Category of the detector. </param>
        /// <param name="supportTopicList"> List of support topics. </param>
        /// <param name="analysisTypes"> List of analysis types. </param>
        /// <param name="score"> Authors' names of the detector. </param>
        /// <returns> A new <see cref="Models.ContainerAppDiagnosticsMetadata"/> instance for mocking. </returns>
        public static ContainerAppDiagnosticsMetadata ContainerAppDiagnosticsMetadata(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, string author = null, string category = null, IEnumerable<ContainerAppDiagnosticSupportTopic> supportTopicList = null, IEnumerable<string> analysisTypes = null, float? score = null)
        {
            supportTopicList ??= new List<ContainerAppDiagnosticSupportTopic>();
            analysisTypes ??= new List<string>();

            return new ContainerAppDiagnosticsMetadata(
                id,
                name,
                resourceType,
                systemData,
                description,
                author,
                category,
                supportTopicList?.ToList(),
                analysisTypes?.ToList(),
                score,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppDiagnosticSupportTopic"/>. </summary>
        /// <param name="id"> Unique topic identifier. </param>
        /// <param name="pesId"> PES identifier. </param>
        /// <returns> A new <see cref="Models.ContainerAppDiagnosticSupportTopic"/> instance for mocking. </returns>
        public static ContainerAppDiagnosticSupportTopic ContainerAppDiagnosticSupportTopic(string id = null, string pesId = null)
        {
            return new ContainerAppDiagnosticSupportTopic(id, pesId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppManagedEnvironmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> Kind of the Environment. </param>
        /// <param name="provisioningState"> Provisioning state of the Environment. </param>
        /// <param name="daprAIInstrumentationKey"> Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry. </param>
        /// <param name="daprAIConnectionString"> Application Insights connection string used by Dapr to export Service to Service communication telemetry. </param>
        /// <param name="vnetConfiguration"> Vnet configuration for the environment. </param>
        /// <param name="deploymentErrors"> Any errors that occurred during deployment or deployment validation. </param>
        /// <param name="defaultDomain"> Default Domain Name for the cluster. </param>
        /// <param name="staticIP"> Static IP of the Environment. </param>
        /// <param name="appLogsConfiguration">
        /// Cluster configuration which enables the log daemon to export
        /// app logs to a destination. Currently only "log-analytics" is
        /// supported
        /// </param>
        /// <param name="isZoneRedundant"> Whether or not this Managed Environment is zone-redundant. </param>
        /// <param name="customDomainConfiguration"> Custom domain configuration for the environment. </param>
        /// <param name="eventStreamEndpoint"> The endpoint of the eventstream of the Environment. </param>
        /// <param name="workloadProfiles"> Workload profiles configured for the Managed Environment. </param>
        /// <param name="kedaVersion"> The configuration of Keda component. </param>
        /// <param name="daprVersion"> The configuration of Dapr component. </param>
        /// <param name="infrastructureResourceGroup"> Name of the platform-managed resource group created for the Managed Environment to host infrastructure resources. If a subnet ID is provided, this resource group will be created in the same subscription as the subnet. </param>
        /// <param name="isMtlsEnabled"> Peer authentication settings for the Managed Environment. </param>
        /// <param name="isEnabled"> Peer traffic settings for the Managed Environment. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppManagedEnvironmentData"/> instance for mocking. </returns>
        public static ContainerAppManagedEnvironmentData ContainerAppManagedEnvironmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string kind = null, ContainerAppEnvironmentProvisioningState? provisioningState = null, string daprAIInstrumentationKey = null, string daprAIConnectionString = null, ContainerAppVnetConfiguration vnetConfiguration = null, string deploymentErrors = null, string defaultDomain = null, IPAddress staticIP = null, ContainerAppLogsConfiguration appLogsConfiguration = null, bool? isZoneRedundant = null, ContainerAppCustomDomainConfiguration customDomainConfiguration = null, string eventStreamEndpoint = null, IEnumerable<ContainerAppWorkloadProfile> workloadProfiles = null, string kedaVersion = null, string daprVersion = null, string infrastructureResourceGroup = null, bool? isMtlsEnabled = null, bool? isEnabled = null)
        {
            tags ??= new Dictionary<string, string>();
            workloadProfiles ??= new List<ContainerAppWorkloadProfile>();

            return new ContainerAppManagedEnvironmentData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                kind,
                provisioningState,
                daprAIInstrumentationKey,
                daprAIConnectionString,
                vnetConfiguration,
                deploymentErrors,
                defaultDomain,
                staticIP,
                appLogsConfiguration,
                isZoneRedundant,
                customDomainConfiguration,
                eventStreamEndpoint,
                workloadProfiles?.ToList(),
                kedaVersion != null ? new KedaConfiguration(kedaVersion, serializedAdditionalRawData: null) : null,
                daprVersion != null ? new DaprConfiguration(daprVersion, serializedAdditionalRawData: null) : null,
                infrastructureResourceGroup,
                isMtlsEnabled != null ? new ManagedEnvironmentPropertiesPeerAuthentication(new Mtls(isMtlsEnabled, serializedAdditionalRawData: null), serializedAdditionalRawData: null) : null,
                isEnabled != null ? new ManagedEnvironmentPropertiesPeerTrafficConfiguration(new ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption(isEnabled, serializedAdditionalRawData: null), serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials in code. </param>
        /// <param name="provisioningState"> Provisioning state of the Container Apps Job. </param>
        /// <param name="environmentId"> Resource ID of environment. </param>
        /// <param name="workloadProfileName"> Workload profile name to pin for container apps job execution. </param>
        /// <param name="configuration"> Container Apps Job configuration properties. </param>
        /// <param name="template"> Container Apps job definition. </param>
        /// <param name="outboundIPAddresses"> Outbound IP Addresses of a container apps job. </param>
        /// <param name="eventStreamEndpoint"> The endpoint of the eventstream of the container apps job. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppJobData"/> instance for mocking. </returns>
        public static ContainerAppJobData ContainerAppJobData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, ContainerAppJobProvisioningState? provisioningState = null, string environmentId = null, string workloadProfileName = null, ContainerAppJobConfiguration configuration = null, ContainerAppJobTemplate template = null, IEnumerable<string> outboundIPAddresses = null, string eventStreamEndpoint = null)
        {
            tags ??= new Dictionary<string, string>();
            outboundIPAddresses ??= new List<string>();

            return new ContainerAppJobData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                provisioningState,
                environmentId,
                workloadProfileName,
                configuration,
                template,
                outboundIPAddresses?.ToList(),
                eventStreamEndpoint,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppJobExecutionBase"/>. </summary>
        /// <param name="name"> Job execution name. </param>
        /// <param name="id"> Job execution Id. </param>
        /// <returns> A new <see cref="Models.ContainerAppJobExecutionBase"/> instance for mocking. </returns>
        public static ContainerAppJobExecutionBase ContainerAppJobExecutionBase(string name = null, string id = null)
        {
            return new ContainerAppJobExecutionBase(name, id, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppJobExecutions"/>. </summary>
        /// <param name="value"> Collection of resources. </param>
        /// <param name="nextLink"> Link to next page of resources. </param>
        /// <returns> A new <see cref="Models.ContainerAppJobExecutions"/> instance for mocking. </returns>
        public static ContainerAppJobExecutions ContainerAppJobExecutions(IEnumerable<ContainerAppJobExecutionData> value = null, string nextLink = null)
        {
            value ??= new List<ContainerAppJobExecutionData>();

            return new ContainerAppJobExecutions(value?.ToList(), nextLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppJobExecutionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="status"> Current running State of the job. </param>
        /// <param name="startOn"> Job execution start time. </param>
        /// <param name="endOn"> Job execution end time. </param>
        /// <param name="template"> Job's execution container. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppJobExecutionData"/> instance for mocking. </returns>
        public static ContainerAppJobExecutionData ContainerAppJobExecutionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, JobExecutionRunningState? status = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, ContainerAppJobExecutionTemplate template = null)
        {
            return new ContainerAppJobExecutionData(
                id,
                name,
                resourceType,
                systemData,
                status,
                startOn,
                endOn,
                template,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppManagedCertificateData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Certificate resource specific properties. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppManagedCertificateData"/> instance for mocking. </returns>
        public static ContainerAppManagedCertificateData ContainerAppManagedCertificateData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedCertificateProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ContainerAppManagedCertificateData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedCertificateProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the certificate. </param>
        /// <param name="subjectName"> Subject name of the certificate. </param>
        /// <param name="error"> Any error occurred during the certificate provision. </param>
        /// <param name="domainControlValidation"> Selected type of domain control validation for managed certificates. </param>
        /// <param name="validationToken"> A TXT token used for DNS TXT domain control validation when issuing this type of managed certificates. </param>
        /// <returns> A new <see cref="Models.ManagedCertificateProperties"/> instance for mocking. </returns>
        public static ManagedCertificateProperties ManagedCertificateProperties(ContainerAppCertificateProvisioningState? provisioningState = null, string subjectName = null, string error = null, ManagedCertificateDomainControlValidation? domainControlValidation = null, string validationToken = null)
        {
            return new ManagedCertificateProperties(
                provisioningState,
                subjectName,
                error,
                domainControlValidation,
                validationToken,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppEnvironmentAuthToken"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="token"> Auth token value. </param>
        /// <param name="expireOn"> Token expiration date. </param>
        /// <returns> A new <see cref="Models.ContainerAppEnvironmentAuthToken"/> instance for mocking. </returns>
        public static ContainerAppEnvironmentAuthToken ContainerAppEnvironmentAuthToken(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string token = null, DateTimeOffset? expireOn = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ContainerAppEnvironmentAuthToken(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                token,
                expireOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppWorkloadProfileState"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Workload Profile resource specific properties. </param>
        /// <returns> A new <see cref="Models.ContainerAppWorkloadProfileState"/> instance for mocking. </returns>
        public static ContainerAppWorkloadProfileState ContainerAppWorkloadProfileState(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ContainerAppWorkloadProfileStateProperties properties = null)
        {
            return new ContainerAppWorkloadProfileState(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppManagedEnvironmentStorageData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="managedEnvironmentStorageAzureFile"> Storage properties. </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppManagedEnvironmentStorageData"/> instance for mocking. </returns>
        public static ContainerAppManagedEnvironmentStorageData ContainerAppManagedEnvironmentStorageData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ContainerAppAzureFileProperties managedEnvironmentStorageAzureFile = null)
        {
            return new ContainerAppManagedEnvironmentStorageData(
                id,
                name,
                resourceType,
                systemData,
                managedEnvironmentStorageAzureFile != null ? new ManagedEnvironmentStorageProperties(managedEnvironmentStorageAzureFile, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppContainers.ContainerAppSourceControlData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="operationState"> Current provisioning State of the operation. </param>
        /// <param name="repoUri"> The repo url which will be integrated to ContainerApp. </param>
        /// <param name="branch"> The branch which will trigger the auto deployment. </param>
        /// <param name="gitHubActionConfiguration">
        /// Container App Revision Template with all possible settings and the
        /// defaults if user did not provide them. The defaults are populated
        /// as they were at the creation time
        /// </param>
        /// <returns> A new <see cref="AppContainers.ContainerAppSourceControlData"/> instance for mocking. </returns>
        public static ContainerAppSourceControlData ContainerAppSourceControlData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ContainerAppSourceControlOperationState? operationState = null, Uri repoUri = null, string branch = null, ContainerAppGitHubActionConfiguration gitHubActionConfiguration = null)
        {
            return new ContainerAppSourceControlData(
                id,
                name,
                resourceType,
                systemData,
                operationState,
                repoUri,
                branch,
                gitHubActionConfiguration,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppUsage"/>. </summary>
        /// <param name="unit"> An enum describing the unit of usage measurement. </param>
        /// <param name="currentValue"> The current usage of the resource. </param>
        /// <param name="limit"> The maximum permitted usage of the resource. </param>
        /// <param name="name"> The name of the type of usage. </param>
        /// <returns> A new <see cref="Models.ContainerAppUsage"/> instance for mocking. </returns>
        public static ContainerAppUsage ContainerAppUsage(ContainerAppUsageUnit unit = default, float currentValue = default, float limit = default, ContainerAppUsageName name = null)
        {
            return new ContainerAppUsage(unit, currentValue, limit, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerAppUsageName"/>. </summary>
        /// <param name="value"> The name of the resource. </param>
        /// <param name="localizedValue"> The localized name of the resource. </param>
        /// <returns> A new <see cref="Models.ContainerAppUsageName"/> instance for mocking. </returns>
        public static ContainerAppUsageName ContainerAppUsageName(string value = null, string localizedValue = null)
        {
            return new ContainerAppUsageName(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of ContainerAppAuthConfigData. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="platform"> The configuration settings of the platform of ContainerApp Service Authentication/Authorization. </param>
        /// <param name="globalValidation"> The configuration settings that determines the validation flow of users using  Service Authentication/Authorization. </param>
        /// <param name="identityProviders"> The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization. </param>
        /// <param name="login"> The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization. </param>
        /// <param name="httpSettings"> The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.AppContainers.ContainerAppAuthConfigData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static ContainerAppAuthConfigData ContainerAppAuthConfigData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ContainerAppAuthPlatform platform, ContainerAppGlobalValidation globalValidation, ContainerAppIdentityProvidersConfiguration identityProviders, ContainerAppLogin login, ContainerAppHttpSettings httpSettings)
        {
            return ContainerAppAuthConfigData(id: id, name: name, resourceType: resourceType, systemData: systemData, platform: platform, globalValidation: globalValidation, identityProviders: identityProviders, login: login, httpSettings: httpSettings, encryptionSettings: default);
        }

        /// <summary> Initializes a new instance of ContainerAppIngressConfiguration. </summary>
        /// <param name="fqdn"> Hostname. </param>
        /// <param name="external"> Bool indicating if app exposes an external http endpoint. </param>
        /// <param name="targetPort"> Target Port in containers for traffic from ingress. </param>
        /// <param name="exposedPort"> Exposed Port in containers for TCP traffic from ingress. </param>
        /// <param name="transport"> Ingress transport protocol. </param>
        /// <param name="traffic"> Traffic weights for app's revisions. </param>
        /// <param name="customDomains"> custom domain bindings for Container Apps' hostnames. </param>
        /// <param name="allowInsecure"> Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections. </param>
        /// <param name="ipSecurityRestrictions"> Rules to restrict incoming IP address. </param>
        /// <param name="stickySessionsAffinity"> Sticky Sessions for Single Revision Mode. </param>
        /// <param name="clientCertificateMode"> Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate. </param>
        /// <param name="corsPolicy"> CORS policy for container app. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.AppContainers.Models.ContainerAppIngressConfiguration" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static ContainerAppIngressConfiguration ContainerAppIngressConfiguration(string fqdn, bool? external, int? targetPort, int? exposedPort, ContainerAppIngressTransportMethod? transport, IEnumerable<ContainerAppRevisionTrafficWeight> traffic, IEnumerable<ContainerAppCustomDomain> customDomains, bool? allowInsecure, IEnumerable<ContainerAppIPSecurityRestrictionRule> ipSecurityRestrictions, Affinity? stickySessionsAffinity, ContainerAppIngressClientCertificateMode? clientCertificateMode, ContainerAppCorsPolicy corsPolicy)
        {
            return ContainerAppIngressConfiguration(fqdn: fqdn, external: external, targetPort: targetPort, exposedPort: exposedPort, transport: transport, traffic: traffic, customDomains: customDomains, allowInsecure: allowInsecure, ipSecurityRestrictions: ipSecurityRestrictions, stickySessionsAffinity: stickySessionsAffinity, clientCertificateMode: clientCertificateMode, corsPolicy: corsPolicy, additionalPortMappings: default);
        }

        /// <summary> Initializes a new instance of ContainerAppManagedEnvironmentData. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> Kind of the Environment. </param>
        /// <param name="provisioningState"> Provisioning state of the Environment. </param>
        /// <param name="daprAIInstrumentationKey"> Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry. </param>
        /// <param name="daprAIConnectionString"> Application Insights connection string used by Dapr to export Service to Service communication telemetry. </param>
        /// <param name="vnetConfiguration"> Vnet configuration for the environment. </param>
        /// <param name="deploymentErrors"> Any errors that occurred during deployment or deployment validation. </param>
        /// <param name="defaultDomain"> Default Domain Name for the cluster. </param>
        /// <param name="staticIP"> Static IP of the Environment. </param>
        /// <param name="appLogsConfiguration">
        /// Cluster configuration which enables the log daemon to export
        /// app logs to a destination. Currently only "log-analytics" is
        /// supported
        /// </param>
        /// <param name="isZoneRedundant"> Whether or not this Managed Environment is zone-redundant. </param>
        /// <param name="customDomainConfiguration"> Custom domain configuration for the environment. </param>
        /// <param name="eventStreamEndpoint"> The endpoint of the eventstream of the Environment. </param>
        /// <param name="workloadProfiles"> Workload profiles configured for the Managed Environment. </param>
        /// <param name="kedaVersion"> The configuration of Keda component. </param>
        /// <param name="daprVersion"> The configuration of Dapr component. </param>
        /// <param name="infrastructureResourceGroup"> Name of the platform-managed resource group created for the Managed Environment to host infrastructure resources. If a subnet ID is provided, this resource group will be created in the same subscription as the subnet. </param>
        /// <param name="isMtlsEnabled"> Peer authentication settings for the Managed Environment. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.AppContainers.ContainerAppManagedEnvironmentData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static ContainerAppManagedEnvironmentData ContainerAppManagedEnvironmentData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, string kind, ContainerAppEnvironmentProvisioningState? provisioningState, string daprAIInstrumentationKey, string daprAIConnectionString, ContainerAppVnetConfiguration vnetConfiguration, string deploymentErrors, string defaultDomain, IPAddress staticIP, ContainerAppLogsConfiguration appLogsConfiguration, bool? isZoneRedundant, ContainerAppCustomDomainConfiguration customDomainConfiguration, string eventStreamEndpoint, IEnumerable<ContainerAppWorkloadProfile> workloadProfiles, string kedaVersion, string daprVersion, string infrastructureResourceGroup, bool? isMtlsEnabled)
        {
            return ContainerAppManagedEnvironmentData(id: id, name: name, resourceType: resourceType, systemData: systemData, tags: tags, location: location, kind: kind, provisioningState: provisioningState, daprAIInstrumentationKey: daprAIInstrumentationKey, daprAIConnectionString: daprAIConnectionString, vnetConfiguration: vnetConfiguration, deploymentErrors: deploymentErrors, defaultDomain: defaultDomain, staticIP: staticIP, appLogsConfiguration: appLogsConfiguration, isZoneRedundant: isZoneRedundant, customDomainConfiguration: customDomainConfiguration, eventStreamEndpoint: eventStreamEndpoint, workloadProfiles: workloadProfiles, kedaVersion: kedaVersion, daprVersion: daprVersion, infrastructureResourceGroup: infrastructureResourceGroup, isMtlsEnabled: isMtlsEnabled, isEnabled: default);
        }
    }
}
