// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AppContainers
{
    /// <summary> A class representing the ContainerApp data model. </summary>
    public partial class ContainerAppData : TrackedResourceData
    {
        /// <summary> Outbound IP Addresses for container app. </summary>
        [Obsolete("This property is obsolete and will be removed in a future release", false)]
        [EditorBrowsable(EditorBrowsableState.Never)]
        public IReadOnlyList<Uri> OutboundIPAddresses { get; }

        /// <summary> WorkloadProfileType for container app. </summary>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public string WorkloadProfileType { get; set; }
    }
}
