// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using Azure.ResourceManager.AppContainers.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Custom Domain of a Container App. </summary>
    public partial class ContainerAppCustomDomain
    {
        /// <summary> Initializes a new instance of ContainerAppCustomDomain. </summary>
        /// <param name="name"> Hostname. </param>
        /// <param name="certificateId"> Resource Id of the Certificate to be bound to this hostname. Must exist in the Managed Environment. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="certificateId"/> is null. </exception>
        public ContainerAppCustomDomain(string name, ResourceIdentifier certificateId)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(certificateId, nameof(certificateId));

            Name = name;
            CertificateId = certificateId;
        }
    }
}
